/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.middleware.repository;

import cn.com.yusys.yusp.registry.host.config.CommonProperties;
import cn.com.yusys.yusp.registry.host.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.registry.host.exception.DashboardFileException;
import cn.com.yusys.yusp.registry.host.repository.CommonRepository;
import cn.com.yusys.yusp.registry.middleware.domain.MiddleWare;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Repository;

@EnableConfigurationProperties(value={ConfigFileConfiguration.class})
@Repository
public class MiddleWareRepository
extends CommonRepository {
    private final Logger log = LoggerFactory.getLogger(MiddleWareRepository.class);

    public MiddleWareRepository(ConfigFileConfiguration properties) {
        super((CommonProperties)properties.getRegistryStore());
    }

    public JavaType getJavaType() {
        TypeFactory factory = TypeFactory.defaultInstance();
        return factory.constructParametricType(List.class, new Class[]{MiddleWare.class});
    }

    public void addAndUpdateMiddleWare(MiddleWare middleWare) throws DashboardFileException {
        List<MiddleWare> list = this.getMiddleWareList();
        boolean flag = true;
        for (MiddleWare mw : list) {
            if (!mw.getName().equals(middleWare.getName()) || !mw.getVersion().equals(middleWare.getVersion())) continue;
            flag = false;
        }
        if (flag) {
            list.add(middleWare);
        }
        try {
            if (flag) {
                this.getAfo().writeObject(list);
            }
        }
        catch (DashboardFileException e) {
            this.log.error("\u6dfb\u52a0\u5931\u8d25\u5931\u8d25: " + middleWare + " error: " + e.getMessage());
            throw e;
        }
    }

    public void delMiddleWare(String ids) throws DashboardFileException {
        List<MiddleWare> list = this.getMiddleWareList();
        ArrayList<MiddleWare> removeList = null;
        List<String> idList = Arrays.asList(ids.split(","));
        for (MiddleWare mw : list) {
            if (!idList.contains(mw.getId())) continue;
            if (removeList == null) {
                removeList = new ArrayList<MiddleWare>();
            }
            removeList.add(mw);
            File file = new File(mw.getLocalFile());
            if (!file.exists()) continue;
            file.delete();
        }
        if (removeList == null) {
            return;
        }
        list.removeAll(removeList);
        try {
            this.getAfo().writeObject(list);
        }
        catch (DashboardFileException e) {
            e.printStackTrace();
            this.log.error("\u5220\u9664\u4e1a\u52a1\u57df\u5931\u8d25: " + Arrays.asList(ids) + " error: " + e.getMessage());
            throw e;
        }
    }

    public List<MiddleWare> getMiddleWareList() {
        ArrayList list = (ArrayList)this.getLoadObj();
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    public MiddleWare getMiddleWare(String name, String version) {
        List list = (List)this.getLoadObj();
        MiddleWare middleWare = null;
        for (MiddleWare mw0 : list) {
            if (!mw0.getName().equals(name) || !mw0.getVersion().equals(version)) continue;
            middleWare = mw0;
        }
        return middleWare;
    }

    public MiddleWare getMiddleWare(String id) {
        List list = (List)this.getLoadObj();
        MiddleWare middleWare = null;
        for (MiddleWare mw0 : list) {
            if (!mw0.getId().endsWith(id)) continue;
            middleWare = mw0;
        }
        return middleWare;
    }

    public List<String> getMiddleWareVersion(String name) {
        List list = (List)this.getLoadObj();
        ArrayList<String> versionList = new ArrayList<String>();
        for (MiddleWare mw0 : list) {
            if (!mw0.getName().equals(name)) continue;
            versionList.add(mw0.getVersion());
        }
        return versionList;
    }

    public List<String> getMiddleWareNameList() {
        List list = (List)this.getLoadObj();
        HashSet<String> nameSet = new HashSet<String>();
        for (MiddleWare mw0 : list) {
            nameSet.add(mw0.getName());
        }
        return new ArrayList<String>(nameSet);
    }
}

