/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.middleware.repository;

import cn.com.yusys.yusp.registry.host.config.CommonProperties;
import cn.com.yusys.yusp.registry.host.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.registry.host.exception.DashboardFileException;
import cn.com.yusys.yusp.registry.host.repository.CommonRepository;
import cn.com.yusys.yusp.registry.middleware.domain.DeployTask;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Repository;

@EnableConfigurationProperties(value={ConfigFileConfiguration.class})
@Repository
public class DeployTaskRepository
extends CommonRepository {
    private final Logger log = LoggerFactory.getLogger(DeployTaskRepository.class);
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public DeployTaskRepository(ConfigFileConfiguration properties) {
        super((CommonProperties)properties.getRegistryStore());
    }

    public JavaType getJavaType() {
        TypeFactory factory = TypeFactory.defaultInstance();
        return factory.constructParametricType(List.class, new Class[]{DeployTask.class});
    }

    public void addDeployTask(DeployTask deployTask) throws DashboardFileException {
        List<DeployTask> list = this.getDeployTaskList();
        boolean update = false;
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getId().equals(deployTask.getId())) continue;
            update = true;
            index = i;
        }
        deployTask.setCreatedTime(this.sdf.format(new Date()));
        if (update) {
            list.set(index, deployTask);
        } else {
            list.add(deployTask);
        }
        try {
            this.getAfo().writeObject(list);
        }
        catch (DashboardFileException e) {
            this.log.error("\u6dfb\u52a0\u5931\u8d25: " + deployTask + " error: " + e.getMessage());
            throw e;
        }
    }

    public void delDeployTask(String ids) throws DashboardFileException {
        List<DeployTask> list = this.getDeployTaskList();
        ArrayList<DeployTask> removeList = null;
        List<String> idList = Arrays.asList(ids.split(","));
        for (DeployTask dr : list) {
            if (!idList.contains(dr.getId())) continue;
            if (removeList == null) {
                removeList = new ArrayList<DeployTask>();
            }
            removeList.add(dr);
        }
        if (removeList == null) {
            return;
        }
        list.removeAll(removeList);
        try {
            this.getAfo().writeObject(list);
        }
        catch (DashboardFileException e) {
            e.printStackTrace();
            this.log.error("\u5220\u9664\u5931\u8d25: " + Arrays.asList(ids) + " error: " + e.getMessage());
            throw e;
        }
    }

    public List<DeployTask> getDeployTaskList() {
        ArrayList<DeployTask> list = (ArrayList<DeployTask>)this.getLoadObj();
        if (list == null) {
            list = new ArrayList<DeployTask>();
        }
        Collections.sort(list, new Comparator<DeployTask>(){

            @Override
            public int compare(DeployTask o1, DeployTask o2) {
                try {
                    if (DeployTaskRepository.this.sdf.parse(o1.getCreatedTime()).getTime() <= DeployTaskRepository.this.sdf.parse(o2.getCreatedTime()).getTime()) {
                        return 1;
                    }
                    return -1;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        });
        return list;
    }

    public List<DeployTask> getDeployTaskListByUserId(String userId) {
        ArrayList<DeployTask> list = new ArrayList<DeployTask>();
        ArrayList list0 = (ArrayList)this.getLoadObj();
        if (list0 == null) {
            list0 = new ArrayList();
        }
        for (DeployTask result : list0) {
            if (!result.getUserId().equals(userId)) continue;
            list.add(result);
        }
        return list;
    }

    public DeployTask getDeployTaskByid(String id) {
        DeployTask deployResult = null;
        List list0 = (List)this.getLoadObj();
        if (list0 == null) {
            deployResult = new DeployTask();
        }
        for (DeployTask result : list0) {
            if (!result.getId().equals(id)) continue;
            deployResult = result;
        }
        return deployResult;
    }
}

