/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.license;

import cn.com.yusys.license.LicenseManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;

@Configuration
public class LicenseConfiguration {
    private final Logger logger = LoggerFactory.getLogger(LicenseConfiguration.class);
    private Environment env;
    private String licenseModel = "PRO";
    private String licenseFile = "";
    private LicenseManager lManager = LicenseManager.getInstance();

    public LicenseConfiguration(Environment env) {
        this.env = env;
        this.checkLicense();
    }

    private void checkLicense() {
        this.logger.info("Check License File.");
        this.setLicenseConfig();
        this.lManager.initialize();
    }

    private void setLicenseConfig() {
        this.licenseModel = this.env.getProperty("license.licenseModel") == null ? this.licenseModel : this.env.getProperty("license.licenseModel");
        this.licenseFile = this.env.getProperty("license.licenseFile") == null ? this.licenseFile : this.env.getProperty("license.licenseFile");
        this.lManager.setLicenseModel(this.licenseModel);
        this.lManager.setInputStream(this.getLicFileInputStream(this.licenseFile));
    }

    private InputStream getLicFileInputStream(String licenseFile) {
        InputStream inputStream;
        File tf = new File(licenseFile);
        if (tf.exists()) {
            this.logger.debug("License file absolute path:{}", (Object)tf.getAbsolutePath());
            try {
                inputStream = new FileInputStream(tf);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("License\u6587\u4ef6:" + licenseFile + "\u8bfb\u53d6\u5f02\u5e38!!!");
            }
        }
        this.logger.debug("License file relative path:" + licenseFile);
        try {
            ClassPathResource resource = new ClassPathResource(licenseFile);
            inputStream = resource.getInputStream();
        }
        catch (Exception e) {
            throw new RuntimeException("License\u6587\u4ef6:" + licenseFile + "\u4e0d\u5b58\u5728!!!");
        }
        return inputStream;
    }
}

