/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.jenkinsBuild.web.rest;

import cn.com.yusys.yusp.registry.host.common.ResultDto;
import cn.com.yusys.yusp.registry.host.exception.DashboardFileException;
import cn.com.yusys.yusp.registry.jenkinsBuild.domain.JenkinsBuildDomain;
import cn.com.yusys.yusp.registry.jenkinsBuild.service.JenkinsBuildService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/jenkins"})
public class JenkinsBuildResource {
    @Autowired
    private JenkinsBuildService service;

    @GetMapping(value={"/jobcheck"})
    public ResultDto<String> jobCheck(@RequestParam String jenkinsBuildName) throws IOException {
        return new ResultDto((Object)this.service.jobCheck(jenkinsBuildName));
    }

    @GetMapping(value={"/jobbuild"})
    public ResultDto<Map<String, Object>> jobBuild(@RequestParam String jenkinsBuildName, @RequestParam String serviceName) throws IOException, DashboardFileException {
        Map<Object, Object> result = new HashMap();
        result = this.service.jobBuild(jenkinsBuildName, serviceName);
        return new ResultDto(result);
    }

    @GetMapping(value={"/consoleinfo"})
    public ResultDto<String> consoleInfo(@RequestParam String jenkinsBuildName, @RequestParam int buildNumber) throws IOException {
        String result = this.service.consoleInfo(jenkinsBuildName, buildNumber);
        return new ResultDto((Object)result);
    }

    @GetMapping(value={"/buliddetails"})
    public ResultDto<Map<String, Object>> bulidDetails(@RequestParam String jenkinsBuildName, @RequestParam int buildNumber, @RequestParam String serviceName) throws IOException, DashboardFileException {
        Map<Object, Object> result = new HashMap();
        result = this.service.bulidDetails(jenkinsBuildName, buildNumber, serviceName);
        return new ResultDto(result);
    }

    @GetMapping(value={"/getjenkinsinfo"})
    public ResultDto<List<JenkinsBuildDomain>> getJenkinsInfo() {
        return new ResultDto(this.service.getJenkinsInfo());
    }
}

