/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.jenkinsBuild.repository;

import cn.com.yusys.yusp.registry.host.config.CommonProperties;
import cn.com.yusys.yusp.registry.host.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.registry.host.exception.DashboardFileException;
import cn.com.yusys.yusp.registry.host.repository.CommonRepository;
import cn.com.yusys.yusp.registry.jenkinsBuild.domain.JenkinsBuildDomain;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Repository;

@EnableConfigurationProperties(value={ConfigFileConfiguration.class})
@Repository
public class JenkinsBuildRepository
extends CommonRepository {
    private final Logger logger = LoggerFactory.getLogger(JenkinsBuildRepository.class);

    public JenkinsBuildRepository(ConfigFileConfiguration properties) {
        super((CommonProperties)properties.getRegistryStore());
    }

    public JavaType getJavaType() {
        TypeFactory factory = TypeFactory.defaultInstance();
        return factory.constructParametricType(List.class, new Class[]{JenkinsBuildDomain.class});
    }

    public List<JenkinsBuildDomain> getBuildInfo() {
        ArrayList list = (ArrayList)this.getLoadObj();
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    public int addBuildInfo(JenkinsBuildDomain domain) throws DashboardFileException {
        List<JenkinsBuildDomain> list = this.getBuildInfo();
        int count = 0;
        for (JenkinsBuildDomain d : list) {
            if (!d.getName().equals(domain.getName())) continue;
            d.setBuildFlag(domain.getBuildFlag());
            d.setBuildNumber(domain.getBuildNumber());
            ++count;
            break;
        }
        if (count == 0) {
            list.add(domain);
        }
        try {
            this.getAfo().writeObject(list);
        }
        catch (DashboardFileException e) {
            this.logger.error("\u6dfb\u52a0jenkins\u6784\u5efa\u4fe1\u606f\u5931\u8d25: " + domain + " error: " + e.getMessage());
            throw e;
        }
        return 1;
    }
}

