/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.web.rest;

import cn.com.yusys.yusp.registry.governance.domain.WarnRule;
import cn.com.yusys.yusp.registry.governance.service.WarnRuleService;
import cn.com.yusys.yusp.registry.host.common.ResultDto;
import cn.com.yusys.yusp.registry.host.exception.DashboardFileException;
import cn.com.yusys.yusp.registry.host.exception.DashboardParamException;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/warnrule"})
public class WarnRuleResource {
    private final Logger log = LoggerFactory.getLogger(WarnRuleResource.class);
    @Autowired
    WarnRuleService warnRuleService;

    @GetMapping(value={"/"})
    public ResultDto<List<WarnRule>> index() {
        this.log.info("\u67e5\u8be2\u89c4\u5219\u5217\u8868\u4fe1\u606f");
        return new ResultDto(this.warnRuleService.getList());
    }

    @PostMapping(value={"/update"})
    public ResultDto<String> update(@RequestBody WarnRule warnRule) {
        this.log.info("update obj warnRule:{}", (Object)warnRule);
        try {
            this.warnRuleService.update(warnRule);
        }
        catch (DashboardFileException e) {
            return new ResultDto(1001, 0L, "error", (Object)e.getMessage());
        }
        catch (DashboardParamException e) {
            return new ResultDto(1002, 0L, "error", (Object)e.getMessage());
        }
        return new ResultDto((Object)"success");
    }

    @PostMapping(value={"/add"})
    public ResultDto<String> add(@RequestBody WarnRule warnRule) {
        this.log.info("add obj warnRule:{}", (Object)warnRule);
        warnRule.setId(UUID.randomUUID().toString());
        try {
            this.warnRuleService.add(warnRule);
        }
        catch (DashboardFileException e) {
            return new ResultDto(1001, 0L, "error", (Object)e.getMessage());
        }
        catch (DashboardParamException e) {
            return new ResultDto(1002, 0L, "error", (Object)e.getMessage());
        }
        return new ResultDto((Object)"success");
    }

    @GetMapping(value={"/delete/{ids}"})
    public ResultDto<String> delete(@PathVariable(value="ids") String ids) {
        this.log.info("delete obj ids:{}", (Object)ids);
        try {
            this.warnRuleService.delete(ids);
        }
        catch (DashboardParamException e) {
            return new ResultDto(1002, 0L, "error", (Object)e.getMessage());
        }
        return new ResultDto((Object)"success");
    }
}

