/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.web.rest;

import cn.com.yusys.yusp.registry.governance.domain.User;
import cn.com.yusys.yusp.registry.governance.service.UserService;
import cn.com.yusys.yusp.registry.governance.web.rest.BusinessDomainResource;
import cn.com.yusys.yusp.registry.host.common.ResultDto;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/user"})
public class UserResource {
    private static final Logger logger = LoggerFactory.getLogger(BusinessDomainResource.class);
    @Autowired
    private UserService userService;

    @GetMapping(value={"/list"})
    public ResultDto<List<User>> getUserList() {
        logger.info("\u8bf7\u6c42\u63a5\u53e3\uff1a/api/user/list \u67e5\u8be2\u7528\u6237\u5217\u8868");
        List<User> userList = null;
        userList = this.userService.getUserList();
        return new ResultDto((long)userList.size(), userList);
    }

    @PostMapping(value={"/"})
    public ResultDto<String> addUser(@RequestBody @Valid User user) {
        logger.info("\u8bf7\u6c42\u63a5\u53e3\uff1a /api/user/ \u6dfb\u52a0\u7528\u6237\uff0c\u8bf7\u6c42\u53c2\u6570 user: {}", (Object)user);
        if (user.getId() == null || user.getId().equals("")) {
            user.setId(UUID.randomUUID().toString());
        }
        this.userService.addUser(user);
        return new ResultDto((Object)"success");
    }

    @GetMapping(value={"/{userId}"})
    public ResultDto<User> getUserByUserId(@PathVariable String userId) {
        User user = this.userService.getUserByUserId(userId);
        if (user == null) {
            user = new User();
            user.setUserId("admin");
            return new ResultDto((Object)user);
        }
        return new ResultDto((Object)user);
    }

    @GetMapping(value={"/delete/{ids}"})
    public ResultDto<String> delUserByIds(@PathVariable(value="ids") String ids) {
        logger.info("\u8bf7\u6c42\u63a5\u53e3:/api/user/delete/ \u5220\u9664\u7528\u6237\uff0c\u8bf7\u6c42\u53c2\u6570 ids\uff1a{}", (Object)ids);
        try {
            this.userService.delUserByIds(ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((Object)"success");
    }
}

