/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.web.rest;

import cn.com.yusys.yusp.registry.governance.domain.IndexDomain;
import cn.com.yusys.yusp.registry.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.registry.governance.service.ServiceFlexService;
import cn.com.yusys.yusp.registry.host.common.ResultDto;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/service/flex"})
public class ServiceFlexResource {
    private final Logger log = LoggerFactory.getLogger(ServiceFlexResource.class);
    @Autowired
    private ServiceFlexService service;

    @GetMapping(value={"/info"})
    public ResultDto<List<ServiceInfoDomain>> getServiceInfos() {
        this.log.info("\u8bf7\u6c42\u63a5\u53e3:/api/service/flex/info,\u67e5\u8be2\u670d\u52a1\u5217\u8868");
        List<ServiceInfoDomain> serviceInfoDomains = this.service.getServiceInfo();
        return new ResultDto((long)serviceInfoDomains.size(), serviceInfoDomains);
    }

    @GetMapping(value={"/info/{name}"})
    public ResultDto<ServiceInfoDomain> getServicesInfoByName(@PathVariable String name) {
        this.log.info("\u8bf7\u6c42\u63a5\u53e3:/api/service/flex/info,\u67e5\u8be2\u5355\u4e2a\u670d\u52a1:{}", (Object)name);
        return new ResultDto((Object)this.service.getServiceByName(name));
    }

    @GetMapping(value={"/index"})
    public ResultDto<List<IndexDomain>> getIndexByName(String name) {
        this.log.info("\u8bf7\u6c42\u63a5\u53e3:/api/service/flex/info,\u67e5\u8be2\u670d\u52a1\u6307\u6807\u4fe1\u606f,\u8bf7\u6c42\u53c2\u6570\uff1aname:{}", (Object)name);
        return new ResultDto(this.service.getIndexByName(name));
    }

    @PostMapping(value={"/updateindex"})
    public ResultDto<Integer> updateServiceIndex(String name, @RequestBody IndexDomain indicator) {
        this.log.info("\u8bf7\u6c42\u63a5\u53e3:/api/service/flex/updateindex,\u4e3a\u670d\u52a1\u6dfb\u52a0\u6307\u6807\u96c6,\u8bf7\u6c42\u53c2\u6570\uff1aname:{},indicator:{}", (Object)name, (Object)indicator);
        return new ResultDto((Object)this.service.updateIndexByName(name, indicator));
    }

    @PostMapping(value={"/addindex"})
    public ResultDto<Integer> addServiceIndex(String name, @RequestBody IndexDomain indicator) {
        this.log.info("\u8bf7\u6c42\u63a5\u53e3:/api/service/flex/updateindex,\u4e3a\u670d\u52a1\u6dfb\u52a0\u6307\u6807\u96c6,\u8bf7\u6c42\u53c2\u6570\uff1aname:{},indicator:{}", (Object)name, (Object)indicator);
        return new ResultDto((Object)this.service.addIndex(name, indicator));
    }

    @GetMapping(value={"/removeindex"})
    public ResultDto<Integer> removeServiceIndex(String name, String keys) {
        this.log.info("\u8bf7\u6c42\u63a5\u53e3:/api/service/flex/removeindex,\u5220\u9664\u670d\u52a1\u6307\u6807\u96c6,\u8bf7\u6c42\u53c2\u6570\uff1aname:{},keys:{}", (Object)name, (Object)keys);
        return new ResultDto((Object)this.service.removeIndexByName(name, keys));
    }

    @GetMapping(value={"/addinstance"})
    public void addInstance(String name) {
        this.log.info("\u8bf7\u6c42\u63a5\u53e3:/api/service/flex/addinstance,\u6269\u5bb9\u670d\u52a1,\u8bf7\u6c42\u53c2\u6570\uff1aname:{}", (Object)name);
        ResultDto resultDto = new ResultDto();
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            this.service.updateInstance(name, true, null);
        }
    }

    @GetMapping(value={"/downinstance"})
    public void downInstance(String name) {
        this.log.info("\u8bf7\u6c42\u63a5\u53e3:/api/service/flex/downinstance,\u51cf\u5c11\u670d\u52a1,\u8bf7\u6c42\u53c2\u6570\uff1aname:{}", (Object)name);
        ResultDto resultDto = new ResultDto();
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            this.service.updateInstance(name, false, null);
        }
    }
}

