/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.web.rest;

import cn.com.yusys.yusp.registry.gateway.service.RefreshGateway;
import cn.com.yusys.yusp.registry.governance.domain.ServiceDegradationDomain;
import cn.com.yusys.yusp.registry.governance.service.ServiceDegradationService;
import cn.com.yusys.yusp.registry.host.common.ResultDto;
import cn.com.yusys.yusp.registry.log.util.LogUtil;
import cn.com.yusys.yusp.registry.log.util.ModulNameConstant;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ServiceDegradationResource {
    private final Logger log = LoggerFactory.getLogger(ServiceDegradationResource.class);
    @Autowired
    private ServiceDegradationService serviceDegradationService;
    @Autowired
    private RefreshGateway refreshGateway;

    @GetMapping(value={"/cfg/serviceDegradation/info"})
    public ResultDto<List<ServiceDegradationDomain>> getServiceDegradationInfo() {
        ResultDto list = new ResultDto(this.serviceDegradationService.getServiceDegradationList());
        if (list.getData() != null) {
            list.setTotal((long)((List)list.getData()).size());
        }
        LogUtil.info((Object)ModulNameConstant.SERVICE_DEGRADATION, (String)"\u670d\u52a1\u964d\u7ea7\u914d\u7f6e->\u6210\u529f", (Object[])new Object[0]);
        return list;
    }

    @GetMapping(value={"/api/serviceDegradation/paramsinfo"})
    public ResultDto<ServiceDegradationDomain> getServiceDegradation(@RequestParam String name, @RequestParam int page, @RequestParam int size) {
        ResultDto result = new ResultDto();
        if (StringUtils.isEmpty((CharSequence)name)) {
            return result;
        }
        List<ServiceDegradationDomain> list = this.serviceDegradationService.getServiceDegradation(name);
        if (list != null) {
            int total = list.size();
            if (page > 0 && size > 0) {
                list = size * (page - 1) < total ? list.subList(size * (page - 1), size * page > total ? total : size * page) : new ArrayList<ServiceDegradationDomain>();
            }
            result.setData(list);
            result.setTotal((long)total);
        }
        LogUtil.info((Object)ModulNameConstant.SERVICE_DEGRADATION, (String)"\u670d\u52a1\u964d\u7ea7\u914d\u7f6e[{}]->\u6210\u529f", (Object[])new Object[]{name});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/serviceDegradation/updateparams"})
    public ResultDto<Integer> updateLimitParameter(@RequestBody ServiceDegradationDomain serviceDegradationDomain) {
        ResultDto resultDto;
        LogUtil.info((Object)ModulNameConstant.SERVICE_DEGRADATION, (String)"\u7ef4\u62a4\u670d\u52a1\u964d\u7ea7[{}]->\u5f00\u59cb", (Object[])new Object[]{serviceDegradationDomain.getName()});
        try {
            ResultDto r = new ResultDto((Object)this.serviceDegradationService.updateServiceDegradation(serviceDegradationDomain));
            LogUtil.info((Object)ModulNameConstant.SERVICE_DEGRADATION, (String)"\u7ef4\u62a4\u670d\u52a1\u964d\u7ea7[{}]->\u6210\u529f", (Object[])new Object[]{serviceDegradationDomain.getName()});
            resultDto = r;
        }
        catch (Exception e) {
            ResultDto resultDto2;
            try {
                LogUtil.info((Object)ModulNameConstant.SERVICE_DEGRADATION, (String)"\u7ef4\u62a4\u670d\u52a1\u964d\u7ea7[{}]->\u5f02\u5e38\u9000\u51fa", (Object[])new Object[]{serviceDegradationDomain.getName()});
                ResultDto r = new ResultDto();
                r.setCode(1);
                r.setMessage("\u7ef4\u62a4\u670d\u52a1\u964d\u7ea7\u5f02\u5e38\u9000\u51fa");
                resultDto2 = r;
            }
            catch (Throwable throwable) {
                LogUtil.info((Object)ModulNameConstant.SERVICE_DEGRADATION, (String)"\u7ef4\u62a4\u670d\u52a1\u964d\u7ea7[{}]->\u7ed3\u675f", (Object[])new Object[]{serviceDegradationDomain.getName()});
                throw throwable;
            }
            LogUtil.info((Object)ModulNameConstant.SERVICE_DEGRADATION, (String)"\u7ef4\u62a4\u670d\u52a1\u964d\u7ea7[{}]->\u7ed3\u675f", (Object[])new Object[]{serviceDegradationDomain.getName()});
            return resultDto2;
        }
        LogUtil.info((Object)ModulNameConstant.SERVICE_DEGRADATION, (String)"\u7ef4\u62a4\u670d\u52a1\u964d\u7ea7[{}]->\u7ed3\u675f", (Object[])new Object[]{serviceDegradationDomain.getName()});
        return resultDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/api/serviceDegradation/remove"})
    public ResultDto<Integer> removeLimitParameter(@RequestBody ServiceDegradationDomain serviceDegradationDomain) {
        ResultDto resultDto;
        LogUtil.info((Object)ModulNameConstant.SERVICE_DEGRADATION, (String)"\u5220\u9664\u670d\u52a1\u964d\u7ea7[{}]->\u5f00\u59cb", (Object[])new Object[]{serviceDegradationDomain.getName()});
        try {
            ResultDto r = new ResultDto((Object)this.serviceDegradationService.removeServiceDegradation(serviceDegradationDomain));
            LogUtil.info((Object)ModulNameConstant.SERVICE_DEGRADATION, (String)"\u5220\u9664\u670d\u52a1\u964d\u7ea7[{}]->\u6210\u529f", (Object[])new Object[]{serviceDegradationDomain.getName()});
            resultDto = r;
        }
        catch (Exception e) {
            ResultDto resultDto2;
            try {
                LogUtil.info((Object)ModulNameConstant.SERVICE_DEGRADATION, (String)"\u5220\u9664\u670d\u52a1\u964d\u7ea7[{}]->\u5f02\u5e38\u9000\u51fa", (Object[])new Object[]{serviceDegradationDomain.getName()});
                ResultDto r = new ResultDto();
                r.setCode(1);
                r.setMessage("\u5220\u9664\u670d\u52a1\u964d\u7ea7\u5f02\u5e38\u9000\u51fa");
                resultDto2 = r;
            }
            catch (Throwable throwable) {
                LogUtil.info((Object)ModulNameConstant.SERVICE_DEGRADATION, (String)"\u5220\u9664\u670d\u52a1\u964d\u7ea7[{}]->\u7ed3\u675f", (Object[])new Object[]{serviceDegradationDomain.getName()});
                throw throwable;
            }
            LogUtil.info((Object)ModulNameConstant.SERVICE_DEGRADATION, (String)"\u5220\u9664\u670d\u52a1\u964d\u7ea7[{}]->\u7ed3\u675f", (Object[])new Object[]{serviceDegradationDomain.getName()});
            return resultDto2;
        }
        LogUtil.info((Object)ModulNameConstant.SERVICE_DEGRADATION, (String)"\u5220\u9664\u670d\u52a1\u964d\u7ea7[{}]->\u7ed3\u675f", (Object[])new Object[]{serviceDegradationDomain.getName()});
        return resultDto;
    }

    @GetMapping(value={"/api/serviceDegradation/reflushConf"})
    public ResultDto<Map<String, String>> reflushConf() {
        String key = "gatewayconfig:ServiceDegradation";
        List<ServiceDegradationDomain> t = this.serviceDegradationService.getServiceDegradationList();
        ObjectMapper mapper = new ObjectMapper();
        try {
            String value = mapper.writeValueAsString(t);
            return this.refreshGateway.reflushConf(key, value);
        }
        catch (Exception e) {
            ResultDto r = new ResultDto();
            r.setCode(1);
            r.setMessage("\u5b9e\u65f6\u5237\u65b0\u670d\u52a1\u964d\u7ea7\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38");
            return r;
        }
    }
}

