/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.web.rest;

import cn.com.yusys.yusp.registry.gateway.service.RefreshGateway;
import cn.com.yusys.yusp.registry.governance.domain.Application;
import cn.com.yusys.yusp.registry.governance.domain.Instance;
import cn.com.yusys.yusp.registry.governance.domain.InstanceDTO;
import cn.com.yusys.yusp.registry.governance.domain.InstanceList;
import cn.com.yusys.yusp.registry.governance.service.InstanceManagerService;
import cn.com.yusys.yusp.registry.host.common.ResultDto;
import cn.com.yusys.yusp.registry.log.util.LogUtil;
import cn.com.yusys.yusp.registry.log.util.ModulNameConstant;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/instancemanager"})
public class InstanceManagerResource {
    private final Logger log = LoggerFactory.getLogger(InstanceManagerResource.class);
    @Autowired
    private InstanceManagerService instanceManagerService;
    @Autowired
    private RefreshGateway refreshGateway;
    private Function<Instance, InstanceDTO> TO_INSTANCEDTO = new Function<Instance, InstanceDTO>(){

        @Override
        public InstanceDTO apply(Instance instance) {
            if (instance == null) {
                return null;
            }
            InstanceDTO dto = new InstanceDTO();
            dto.setWeighted(instance.getWeighted());
            dto.setIp(instance.getIp());
            dto.setPort(instance.getPort());
            dto.setLable(instance.getLable());
            return dto;
        }
    };

    @GetMapping(value={"/"})
    public ResultDto<Collection<Application>> index(@RequestParam(value="name", required=false) String name) {
        return new ResultDto(this.instanceManagerService.findAll(name));
    }

    @GetMapping(value={"/applist/"})
    public ResultDto<Collection<Application>> getApplicationListByCluster(@RequestParam(value="cluster", required=true) String cluster) {
        return new ResultDto(this.instanceManagerService.getApplicationListByCluster(cluster));
    }

    @GetMapping(value={"/instancelist"})
    public ResultDto<Collection<Instance>> instanceList(@RequestParam(value="name", required=false) String name) {
        this.log.debug("Deliver applications with name= {}", (Object)name);
        return new ResultDto(this.instanceManagerService.findInstanceList(name));
    }

    @GetMapping(value={"/lableinstancelist"})
    public ResultDto<Collection<Instance>> grayList(@RequestParam(value="name", required=true) String name) {
        this.log.debug("Query applications with name= {}", (Object)name);
        Collection<Instance> instanceList = this.instanceManagerService.findInstanceList(name);
        Collection lableInstanceList = instanceList.stream().filter(a -> StringUtils.isNotEmpty((CharSequence)a.getLable()) && a.getLable().indexOf("IP") >= 0).collect(Collectors.toList());
        return new ResultDto((Object)lableInstanceList);
    }

    @PostMapping(value={"/updateweight"})
    public ResultDto<Integer> updateWeight(@RequestBody InstanceList instanceList) {
        int result = 0;
        for (Instance instance : instanceList.getInstanceList()) {
            result += this.instanceManagerService.updateWeight(instance);
        }
        String key = "instanceConfig";
        Collection t = this.instanceManagerService.findInstanceList(null).stream().map(this.TO_INSTANCEDTO).collect(Collectors.toList());
        ObjectMapper mapper = new ObjectMapper();
        try {
            String value = mapper.writeValueAsString((Object)t);
            this.refreshGateway.reflushConf(key, value);
        }
        catch (Exception e) {
            this.log.error("\u4fee\u6539\u7f51\u5173\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
            e.printStackTrace();
        }
        return new ResultDto((Object)result);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Instance> instance(@PathVariable String id) {
        this.log.debug("Deliver application with ID '{}'", (Object)id);
        Instance instance = this.instanceManagerService.findInstance(id);
        if (instance != null) {
            return new ResponseEntity((Object)instance, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/{id}/{method}/"})
    public ResultDto<String> proxy(@PathVariable String id, @PathVariable String method, ServletRequest request) {
        String result;
        try {
            result = this.instanceManagerService.proxy(id, method, request);
            LogUtil.info((Object)ModulNameConstant.INSTANCE_MANAGER, (String)"\u5b9e\u4f8b[{}],\u7aef\u70b9[{}],\u5904\u7406\u7ed3\u679c[{}]", (Object[])new Object[]{id, method, StringUtils.substring((String)result, (int)0, (int)100)});
        }
        catch (Exception e) {
            LogUtil.error((Object)ModulNameConstant.INSTANCE_MANAGER, (String)"\u5b9e\u4f8b[{}],\u7aef\u70b9 [{}],\u5931\u8d25\u539f\u56e0[{}]", (Object[])new Object[]{id, method, e.getMessage()});
            this.log.error("proxy: id::{} , method:{}, message:{}", new Object[]{id, method, e.getMessage()});
            result = e.getMessage();
        }
        return new ResultDto((Object)result);
    }

    @PostMapping(value={"/{id}/{method}"})
    public ResultDto<String> proxyPost(@PathVariable String id, @PathVariable String method, @RequestBody(required=false) String body, HttpServletRequest request) {
        String result;
        try {
            LogUtil.info((Object)ModulNameConstant.INSTANCE_MANAGER, (String)"\u5b9e\u4f8b[{}],\u7aef\u70b9[{}], [post]", (Object[])new Object[]{id, method});
            result = this.instanceManagerService.proxyPost(id, method, body, request);
            LogUtil.info((Object)ModulNameConstant.INSTANCE_MANAGER, (String)"\u5b9e\u4f8b[{}],\u7aef\u70b9[{}],\u5904\u7406\u7ed3\u679c[{}]", (Object[])new Object[]{id, method, StringUtils.substring((String)result, (int)0, (int)100)});
        }
        catch (Exception e) {
            LogUtil.error((Object)ModulNameConstant.INSTANCE_MANAGER, (String)"\u5b9e\u4f8b[{}],\u7aef\u70b9 [{}],\u5931\u8d25\u539f\u56e0[{}]", (Object[])new Object[]{id, method, e.getMessage()});
            this.log.error("proxy: id::{} , method:{}, message:{}", new Object[]{id, method, e.getMessage()});
            result = e.getMessage();
        }
        return new ResultDto((Object)result);
    }

    @PostMapping(value={"/start"})
    public ResultDto<String> sendCmdStart(@RequestBody Instance instance) {
        String result;
        try {
            LogUtil.info((Object)ModulNameConstant.INSTANCE_MANAGER, (String)"\u5b9e\u4f8b[{}],\u7aef\u70b9 [\u6389\u7ebf\u91cd\u542f]", (Object[])new Object[]{instance.getId()});
            result = this.instanceManagerService.sendCmdStart(instance);
        }
        catch (Exception e) {
            LogUtil.error((Object)ModulNameConstant.INSTANCE_MANAGER, (String)"\u5b9e\u4f8b[{}],\u5931\u8d25\u539f\u56e0[{}]", (Object[])new Object[]{instance.getId(), e.getMessage()});
            this.log.error("proxy: id{}, message:{}", (Object)instance.getId(), (Object)e.getMessage());
            result = e.getMessage();
        }
        return new ResultDto((Object)result);
    }
}

