/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.web.rest;

import cn.com.yusys.yusp.registry.governance.domain.Datacode;
import cn.com.yusys.yusp.registry.governance.service.DataDictonaryService;
import cn.com.yusys.yusp.registry.host.common.ResultDto;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/datadict"})
public class DataDictonaryResource {
    private final Logger logger = LoggerFactory.getLogger(DataDictonaryResource.class);
    @Autowired
    private DataDictonaryService service;

    @GetMapping(value={"/datacode"})
    public ResultDto<List<Datacode>> getCodeListByName(String name) {
        this.logger.info("\u8bbf\u95ee\u63a5\u53e3:/api/datadict/datacode,\u53c2\u6570:name:{}", (Object)name);
        List<Datacode> list = this.service.getListByName(name);
        return new ResultDto((long)list.size(), list);
    }

    @PostMapping(value={"/maintain"})
    public ResultDto<Integer> maintainCodeByName(String name, @RequestBody Datacode datacode) {
        this.logger.info("\u8bbf\u95ee\u63a5\u53e3:/api/datadict/maintain,\u53c2\u6570:name:{},datacode:{}", (Object)name, (Object)datacode);
        return new ResultDto((Object)this.service.updateDataCodeByName(name, datacode));
    }

    @GetMapping(value={"/remove"})
    public ResultDto<Integer> removeCodeByKey(String name, String keys) {
        this.logger.info("\u8bbf\u95ee\u63a5\u53e3:/api/datadict/remove,\u53c2\u6570:name:{},keys:{}", (Object)name, (Object)keys);
        return new ResultDto((Object)this.service.removeDataCodeByName(name, keys));
    }
}

