/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.web.rest;

import cn.com.yusys.yusp.registry.governance.domain.Cluster;
import cn.com.yusys.yusp.registry.governance.service.ClusterService;
import cn.com.yusys.yusp.registry.governance.service.InstanceManagerService;
import cn.com.yusys.yusp.registry.governance.service.ServiceInfoService;
import cn.com.yusys.yusp.registry.host.common.ResultDto;
import cn.com.yusys.yusp.registry.host.service.HostService;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cluster"})
public class ClusterResource {
    private static final Logger logger = LoggerFactory.getLogger(ClusterResource.class);
    @Autowired
    private ClusterService clusterService;
    @Autowired
    private HostService hostService;
    @Autowired
    private ServiceInfoService serviceInfoService;
    @Autowired
    private InstanceManagerService instanceManagerService;

    @GetMapping(value={"/list"})
    public ResultDto<List<Cluster>> getClusterList() {
        logger.info("\u8bf7\u6c42\u63a5\u53e3: /api/cluster/list \u67e5\u8be2\u96c6\u7fa4\u5217\u8868");
        List<Cluster> clusterList = null;
        clusterList = this.clusterService.getClusterList();
        return new ResultDto((long)clusterList.size(), clusterList);
    }

    @PostMapping(value={"/"})
    public ResultDto<String> addCluster(@RequestBody @Valid Cluster cluster) {
        logger.info("\u8bf7\u6c42\u63a5\u53e3: /api/cluster/ \u6dfb\u52a0\u96c6\u7fa4\uff0c\u8bf7\u6c42\u53c2\u6570 cluster: {}", (Object)cluster);
        if (cluster.getId() == null || cluster.getId().equals("")) {
            cluster.setId(UUID.randomUUID().toString());
        }
        this.clusterService.addCluster(cluster);
        return new ResultDto((Object)"success");
    }

    @GetMapping(value={"/{clusterName}"})
    public ResultDto<Cluster> getClusterByName(@PathVariable String clusterName) {
        Cluster cluster = this.clusterService.getClusterByClusterName(clusterName);
        return new ResultDto((Object)cluster);
    }

    @GetMapping(value={"/outline"})
    public ResultDto<HashMap> getClusterOutline(@RequestParam(required=false) String cluster) {
        HashMap<String, Integer> clusterOutlineMap = new HashMap<String, Integer>();
        int hostCount = this.hostService.getHostsByCluster(cluster).size();
        int registryCount = this.serviceInfoService.getServiceInfoListByCluster(cluster).size();
        int appCount = this.instanceManagerService.getApplicationListByCluster(cluster).size();
        int instanceCount = this.instanceManagerService.getInstanceListByCluster(cluster).size();
        clusterOutlineMap.put("hostCount", hostCount);
        clusterOutlineMap.put("registryCount", registryCount);
        clusterOutlineMap.put("appCount", appCount);
        clusterOutlineMap.put("instanceCount", instanceCount);
        return new ResultDto(clusterOutlineMap);
    }

    @GetMapping(value={"/delete/{ids}"})
    public ResultDto<String> delClusterByIds(@PathVariable(value="ids") String ids) {
        logger.info("\u8bf7\u6c42\u63a5\u53e3:/api/cluster/delete/ \u5220\u9664\u96c6\u7fa4,\u8bf7\u6c42\u53c2\u6570ids: {}", (Object)ids);
        try {
            this.clusterService.delClusterByIds(ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((Object)"success");
    }
}

