/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.web.rest;

import cn.com.yusys.yusp.registry.governance.domain.BusinessDomain;
import cn.com.yusys.yusp.registry.governance.service.BusinessDomainService;
import cn.com.yusys.yusp.registry.host.common.ResultDto;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/businessdomain"})
public class BusinessDomainResource {
    private static final Logger logger = LoggerFactory.getLogger(BusinessDomainResource.class);
    @Autowired
    private BusinessDomainService service;

    @GetMapping(value={"/list"})
    public ResultDto<List<BusinessDomain>> getBusinessDomainList() {
        logger.info("\u8bf7\u6c42\u63a5\u53e3:/api/businessdomain/list \u67e5\u8be2\u4e1a\u52a1\u57df\u5217\u8868");
        List<BusinessDomain> list = null;
        try {
            list = this.service.getBusinessDomainList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((long)list.size(), list);
    }

    @GetMapping(value={"/{id}"})
    public ResultDto<BusinessDomain> getBusinessDomain(@PathVariable(value="id") String id) {
        logger.info("\u8bf7\u6c42\u63a5\u53e3:/api/businessdomain/ \u67e5\u8be2\u4e1a\u52a1\u57df\uff0c\u8bf7\u6c42\u53c2\u6570 id\uff1a" + id);
        BusinessDomain domain = null;
        try {
            domain = this.service.getBusinessDomain(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((Object)domain);
    }

    @PostMapping(value={"/"})
    public ResultDto<String> addBusinessDomain(@RequestBody @Valid BusinessDomain businessDomain) {
        logger.info("\u8bf7\u6c42\u63a5\u53e3:/api/businessdomain/ \u6dfb\u52a0\u4e1a\u52a1\u57df\uff0c\u8bf7\u6c42\u53c2\u6570 businessDomain\uff1a" + businessDomain);
        if (businessDomain.getId() == null || businessDomain.getId().equals("")) {
            businessDomain.setId(UUID.randomUUID().toString());
        }
        try {
            this.service.addBussinessDomain(businessDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((Object)"success");
    }

    @GetMapping(value={"/delete/{ids}"})
    public ResultDto<String> delBusinessDomain(@PathVariable(value="ids") String ids) {
        logger.info("\u8bf7\u6c42\u63a5\u53e3:/api/businessdomain/ \u5220\u9664\u4e1a\u52a1\u57df\uff0c\u8bf7\u6c42\u53c2\u6570 id\uff1a" + ids);
        try {
            this.service.delBusinessDomain(ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultDto(-1, 0L, e.getMessage(), null);
        }
        return new ResultDto((Object)"success");
    }
}

