/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.web.rest;

import cn.com.yusys.yusp.registry.governance.domain.Application;
import cn.com.yusys.yusp.registry.governance.domain.Instance;
import cn.com.yusys.yusp.registry.governance.install.DeployStatus;
import cn.com.yusys.yusp.registry.governance.repository.ApplicationRepository;
import cn.com.yusys.yusp.registry.governance.service.InstanceManagerService;
import cn.com.yusys.yusp.registry.host.common.ResultDto;
import cn.com.yusys.yusp.registry.log.util.LogUtil;
import cn.com.yusys.yusp.registry.log.util.ModulNameConstant;
import com.netflix.appinfo.InstanceInfo;
import java.util.Collection;
import javax.servlet.ServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/applicationmanager"})
public class ApplicationManagerResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationManagerResource.class);
    @Autowired
    private ApplicationRepository repository;
    @Autowired
    private InstanceManagerService instanceManagerService;

    @PostMapping(value={"/start"})
    public ResultDto<String> applicationsStart(@RequestBody String applicationName, ServletRequest request) {
        Collection<Application> applicationList = this.instanceManagerService.findAll(applicationName);
        Application application = null;
        if (applicationList == null || applicationList.isEmpty()) {
            return new ResultDto((Object)"failed");
        }
        application = applicationList.iterator().next();
        int total = application.getInstances().size();
        LogUtil.info((Object)ModulNameConstant.APPLICATION_MANAGER, (String)"\u5f00\u59cb\u96c6\u7fa4[{}]\u542f\u52a8,\u5f85\u5904\u7406[{}]", (Object[])new Object[]{applicationName, total});
        for (Instance instance : application.getInstances()) {
            try {
                LogUtil.info((Object)ModulNameConstant.APPLICATION_MANAGER, (String)"\u5b9e\u4f8b[{}]\u91cd\u542f->\u5f00\u59cb", (Object[])new Object[]{instance.getIp()});
                String responseMsg = null;
                if (instance.getStatus().equals(InstanceInfo.InstanceStatus.UP.name())) {
                    responseMsg = this.instanceManagerService.reStart(instance.getId());
                } else if (instance.getStatus().equals(DeployStatus.OFFLINE.name())) {
                    responseMsg = this.instanceManagerService.sendCmdStart(instance);
                } else {
                    LogUtil.warn((Object)ModulNameConstant.APPLICATION_MANAGER, (String)"\u5b9e\u4f8b[{}],\u672a\u91cd\u542f,\u72b6\u6001[{}]\u4e0d\u5728[{},{}]\u8303\u56f4\u5185", (Object[])new Object[]{instance.getIp(), instance.getStatus(), InstanceInfo.InstanceStatus.UP, DeployStatus.OFFLINE});
                }
                LogUtil.info((Object)ModulNameConstant.APPLICATION_MANAGER, (String)"\u5b9e\u4f8b[{}]\u91cd\u542f->{}", (Object[])new Object[]{instance.getIp(), responseMsg});
            }
            catch (Exception e) {
                e.printStackTrace();
                LogUtil.error((Object)ModulNameConstant.APPLICATION_MANAGER, (String)"\u5b9e\u4f8b[{}]\u91cd\u542f->{}", (Object[])new Object[]{instance.getIp(), e.getMessage()});
            }
        }
        LogUtil.info((Object)ModulNameConstant.APPLICATION_MANAGER, (String)"\u7ed3\u675f\u96c6\u7fa4[{}]\u542f\u52a8", (Object[])new Object[]{applicationName});
        return new ResultDto((Object)"success");
    }

    @PostMapping(value={"/shutdown"})
    public ResultDto<String> applicationsStop(@RequestBody String name, ServletRequest request) {
        LOGGER.info("name:{}", (Object)name);
        Application application = this.instanceManagerService.loadConfigInfo(this.repository.findByName(name));
        int total = application.getInstances().size();
        LogUtil.info((Object)ModulNameConstant.APPLICATION_MANAGER, (String)"\u5f00\u59cb\u96c6\u7fa4[{}]\u542f\u52a8,\u5f85\u5904\u7406[{}]", (Object[])new Object[]{name, total});
        for (Instance instance : application.getInstances()) {
            try {
                LogUtil.info((Object)ModulNameConstant.APPLICATION_MANAGER, (String)"\u5b9e\u4f8b[{}]\u5173\u95ed->\u5f00\u59cb", (Object[])new Object[]{instance.getIp()});
                String responseMsg = null;
                if (instance.getStatus().equals(InstanceInfo.InstanceStatus.UP.name())) {
                    responseMsg = this.instanceManagerService.shutDown(instance.getId());
                }
                LogUtil.info((Object)ModulNameConstant.APPLICATION_MANAGER, (String)"\u5b9e\u4f8b[{}]\u5173\u95ed[{}]->{}", (Object[])new Object[]{instance.getIp(), responseMsg});
            }
            catch (Exception e) {
                e.printStackTrace();
                LogUtil.error((Object)ModulNameConstant.APPLICATION_MANAGER, (String)"\u5b9e\u4f8b[{}]\u5173\u95ed[{}]->{}", (Object[])new Object[]{instance.getIp(), e.getMessage()});
            }
        }
        LogUtil.info((Object)ModulNameConstant.APPLICATION_MANAGER, (String)"\u7ed3\u675f\u96c6\u7fa4[{}]\u542f\u52a8", (Object[])new Object[]{name});
        return new ResultDto((Object)"success");
    }

    @PostMapping(value={"/update"})
    public ResultDto<Application> applicationsUpdate(@RequestBody String applicationName) {
        return new ResultDto();
    }

    @PostMapping(value={"/cancelupdate"})
    public ResultDto<Application> applicationsCancelupdate(@RequestBody String applicationName) {
        return new ResultDto();
    }

    @PostMapping(value={"/remove"})
    public ResultDto<Application> applicationsRemove(@RequestBody String applicationName) {
        return new ResultDto();
    }
}

