/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.service;

import cn.com.yusys.yusp.registry.governance.domain.MonitorResult;
import cn.com.yusys.yusp.registry.governance.domain.WarnEvent;
import cn.com.yusys.yusp.registry.governance.domain.WarnRule;
import cn.com.yusys.yusp.registry.governance.domain.WarnRuleHistory;
import cn.com.yusys.yusp.registry.governance.executor.WarnMonitor;
import cn.com.yusys.yusp.registry.governance.repository.WarnRuleRepository;
import cn.com.yusys.yusp.registry.governance.service.WarnRuleHistoryService;
import cn.com.yusys.yusp.registry.host.exception.DashboardFileException;
import cn.com.yusys.yusp.registry.host.exception.DashboardParamException;
import cn.com.yusys.yusp.registry.log.util.LogUtil;
import cn.com.yusys.yusp.registry.log.util.ModulNameConstant;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;

@Service
public class WarnRuleService {
    private final Logger log = LoggerFactory.getLogger(WarnRuleService.class);
    @Autowired
    private WarnRuleRepository warnRuleRepository;
    @Autowired
    private ThreadPoolTaskScheduler threadPoolTaskScheduler;
    @Autowired
    private WarnMonitor warnMonitor;
    @Autowired
    private WarnRuleHistoryService warnRuleHistoryService;
    @Autowired
    private ApplicationContext applicationContext;
    Map<String, ScheduledFuture> scheduleMap = new ConcurrentHashMap<String, ScheduledFuture>();
    Map<String, Integer> CountMap = new ConcurrentHashMap<String, Integer>();

    public List<WarnRule> getList() {
        return this.warnRuleRepository.getList();
    }

    public void update(WarnRule warnRule) throws DashboardParamException, DashboardFileException {
        LogUtil.info((Object)ModulNameConstant.WARNRULECONFIG, (String)"\u66f4\u65b0\u9884\u8b66\u89c4\u5219", (Object[])new Object[]{warnRule});
        this.warnRuleRepository.update(warnRule);
        this.stopSchedule(warnRule.getId());
        this.startSchedule(warnRule);
    }

    public void add(WarnRule warnRule) throws DashboardParamException, DashboardFileException {
        LogUtil.info((Object)ModulNameConstant.WARNRULECONFIG, (String)"\u65b0\u589e\u9884\u8b66\u89c4\u5219", (Object[])new Object[]{warnRule});
        this.warnRuleRepository.update(warnRule);
        this.startSchedule(warnRule);
    }

    public void delete(String ids) throws DashboardParamException {
        LogUtil.info((Object)ModulNameConstant.WARNRULECONFIG, (String)"\u5220\u9664\u9884\u8b66\u89c4\u5219 ids: ", (Object[])new Object[]{ids});
        this.warnRuleRepository.delete(ids);
        for (String id : ids.split(",")) {
            this.stopSchedule(id);
        }
    }

    public void startSchedule(final WarnRule warnRule) {
        int start = Integer.parseInt(warnRule.getStartTime());
        int end = Integer.parseInt(warnRule.getEndTime()) - 1;
        int interval = 0;
        if (warnRule.getInterval().substring(warnRule.getInterval().length() - 1, warnRule.getInterval().length()).equals("M")) {
            interval = Integer.parseInt(warnRule.getInterval().split("M")[0]);
        }
        String cronStr = "0 0/" + interval + " " + start + "-" + end + " * * ?";
        ScheduledFuture future = this.threadPoolTaskScheduler.schedule(new Runnable(){

            @Override
            public void run() {
                LogUtil.info((Object)ModulNameConstant.WARNRULECONFIG, (String)"\u5b9a\u65f6\u9884\u8b66\u626b\u63cf", (Object[])new Object[]{warnRule});
                MonitorResult result = WarnRuleService.this.warnMonitor.beyondIndex(warnRule);
                if (result.isFlag()) {
                    WarnRuleService.this.sendWarnning(warnRule.getAlertType(), warnRule.getTarget(), (String)result.getResultMap().get("content"));
                    LogUtil.warn((Object)ModulNameConstant.WARNRULECONFIG, (String)((String)result.getResultMap().get("content")), (Object[])new Object[]{warnRule});
                    try {
                        WarnRuleService.this.warnRuleHistoryService.addHistory(new WarnRuleHistory(UUID.randomUUID().toString(), warnRule, (String)result.getResultMap().get("content"), new Date()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }, (Trigger)new CronTrigger(cronStr));
        if (this.scheduleMap.get(warnRule.getId()) == null) {
            this.scheduleMap.put(warnRule.getId(), future);
            System.out.println("\u6dfb\u52a0\u4efb\u52a1 " + this.scheduleMap);
        }
    }

    private void calculateCount(String id) {
        if (this.CountMap.get(id) == null) {
            this.CountMap.put(id, 1);
        } else {
            int count = this.CountMap.get(id);
            this.CountMap.put(id, ++count);
        }
    }

    public void stopSchedule(String id) {
        if (id != null && this.scheduleMap.get(id) != null) {
            this.scheduleMap.get(id).cancel(true);
            this.scheduleMap.remove(id);
            LogUtil.info((Object)ModulNameConstant.WARNRULECONFIG, (String)"\u5173\u95ed\u9884\u8b66", (Object[])new Object[]{id});
        }
    }

    public boolean compare(double d1, double d2, String str) {
        boolean flag = false;
        if (str.equals("gte")) {
            boolean bl = flag = d1 >= d2;
        }
        if (str.equals("lte")) {
            flag = d1 <= d2;
        }
        return flag;
    }

    public void sendWarnning(String type, String target, String content) {
        this.applicationContext.publishEvent((ApplicationEvent)new WarnEvent(UUID.randomUUID(), type, target, content));
    }

    public String formatDouble(double d) {
        BigDecimal b = BigDecimal.valueOf(d);
        return b.setScale(2, 4).toPlainString();
    }
}

