/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.service;

import cn.com.yusys.yusp.registry.governance.domain.Application;
import cn.com.yusys.yusp.registry.governance.domain.DeployInfo;
import cn.com.yusys.yusp.registry.governance.domain.Instance;
import cn.com.yusys.yusp.registry.governance.install.DeployStatus;
import cn.com.yusys.yusp.registry.governance.install.ServiceInstall;
import cn.com.yusys.yusp.registry.governance.repository.ApplicationRepository;
import cn.com.yusys.yusp.registry.governance.repository.DeployRepository;
import cn.com.yusys.yusp.registry.governance.repository.InstanceRepository;
import cn.com.yusys.yusp.registry.governance.repository.ServiceInfoRepository;
import cn.com.yusys.yusp.registry.host.exception.DashboardParamException;
import com.google.common.collect.Lists;
import com.netflix.appinfo.InstanceInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InstanceManagerService {
    private final Logger log = LoggerFactory.getLogger(InstanceManagerService.class);
    @Autowired
    private InstanceRepository instanceRepository;
    @Autowired
    private DeployRepository dDeployRepository;
    @Autowired
    private ApplicationRepository repository;
    @Autowired
    private ServiceInstall serviceInstall;
    @Autowired
    private ServiceInfoRepository serviceInfoRepository;

    public List<Instance> getList() {
        return this.instanceRepository.getList();
    }

    public int updateWeight(Instance instance) {
        try {
            this.instanceRepository.updateInstance(instance);
        }
        catch (DashboardParamException e) {
            e.printStackTrace();
        }
        return 1;
    }

    public Collection<Application> loadConfigInfo(Collection<Application> applicationList) {
        List<Instance> instanceList = this.instanceRepository.getList();
        for (Instance instance : instanceList) {
            String name = instance.getId().split("@")[0];
            List appListTmp = applicationList.stream().filter(a -> a.getName().equals(name)).collect(Collectors.toList());
            if (appListTmp.size() > 0) {
                List insTmp = ((Application)appListTmp.get(0)).getInstances().stream().filter(a -> a.getUrl().equals(instance.getUrl())).collect(Collectors.toList());
                if (insTmp.size() > 0) {
                    ((Instance)insTmp.get(0)).setWeighted(instance.getWeighted());
                    ((Instance)insTmp.get(0)).setLable(instance.getLable());
                    continue;
                }
                if (!instance.getStatus().equals(InstanceInfo.InstanceStatus.UP.name())) continue;
                instance.setStatus(InstanceInfo.InstanceStatus.UNKNOWN.name());
                continue;
            }
            if (!instance.getStatus().equals(InstanceInfo.InstanceStatus.UP.name())) continue;
            instance.setStatus(InstanceInfo.InstanceStatus.UNKNOWN.name());
        }
        return applicationList;
    }

    public Application loadConfigInfo(Application application) {
        List<Instance> instanceList = this.instanceRepository.getList();
        if (application == null) {
            return application;
        }
        for (Instance instance : instanceList) {
            String name = instance.getId().split("@")[0];
            if (!name.equals(application.getName())) continue;
            List insTmp = null;
            if (application != null && application.getInstances() != null) {
                insTmp = application.getInstances().stream().filter(a -> a.getUrl().equals(instance.getUrl())).collect(Collectors.toList());
            }
            if (insTmp != null && insTmp.size() > 0) {
                ((Instance)insTmp.get(0)).setWeighted(instance.getWeighted());
                ((Instance)insTmp.get(0)).setLable(instance.getLable());
                continue;
            }
            if (!instance.getStatus().equals(InstanceInfo.InstanceStatus.UP.name())) continue;
            instance.setStatus(InstanceInfo.InstanceStatus.UNKNOWN.name());
        }
        return application;
    }

    public Collection<Application> loadDeployInfo(Collection<Application> applicationList) {
        List<DeployInfo> listDeploy = this.dDeployRepository.getList();
        for (DeployInfo deployInfo : listDeploy) {
            if (deployInfo.getDeployNo() != DeployStatus.RUNNING.getStepNo()) continue;
            String name = deployInfo.getName();
            List appListTmp = applicationList.stream().filter(a -> a.getName().equals(name)).collect(Collectors.toList());
            if (appListTmp.size() > 0) {
                List instanceList = ((Application)appListTmp.get(0)).getInstances().stream().filter(a -> a.getIp().equals(deployInfo.getIp()) && a.getPort() == deployInfo.getPort()).collect(Collectors.toList());
                if (instanceList.size() != 0) continue;
                ((Application)appListTmp.get(0)).getInstances().add(this.buildInstanceInfo(deployInfo, DeployStatus.OFFLINE));
                continue;
            }
            applicationList.add(new Application(name, Lists.newArrayList((Object[])new Instance[]{this.buildInstanceInfo(deployInfo, DeployStatus.OFFLINE)})));
        }
        return applicationList;
    }

    public Application loadDeployInfo(Application application) {
        List<DeployInfo> listDeploy = this.dDeployRepository.getList();
        for (DeployInfo deployInfo : listDeploy) {
            List instanceList;
            String name = deployInfo.getName();
            if (deployInfo.getDeployNo() != DeployStatus.RUNNING.getStepNo() || !name.equals(application.getName()) || (instanceList = application.getInstances().stream().filter(a -> a.getIp().equals(deployInfo.getIp()) && a.getPort() == deployInfo.getPort()).collect(Collectors.toList())).size() != 0) continue;
            application.getInstances().add(this.buildInstanceInfo(deployInfo, DeployStatus.OFFLINE));
        }
        return application;
    }

    private Instance buildInstanceInfo(DeployInfo deployInfo, DeployStatus deployStatus) {
        Instance instance = new Instance();
        instance.setName(deployInfo.getIp() + ":" + deployInfo.getPort());
        instance.setId(deployInfo.getName() + "@" + deployInfo.getIp() + ":" + deployInfo.getPort());
        instance.setIp(deployInfo.getIp());
        instance.setPort(deployInfo.getPort());
        instance.setStatus(deployStatus.name());
        instance.setUrl("http://" + deployInfo.getIp() + ":" + deployInfo.getPort());
        instance.setVersion(deployInfo.getVersion());
        instance.setDeployNo(deployInfo.getDeployNo());
        instance.setDeployDesc(deployInfo.getDeployDesc());
        return instance;
    }

    public Collection<Instance> findInstanceList(String name) {
        this.log.debug("findInstanceList Instances with name= {}", (Object)name);
        Collection<Application> applicationList = this.findAll(name);
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        for (Application application : applicationList) {
            instanceList.addAll(application.getInstances());
        }
        return instanceList;
    }

    public Collection<Application> findAll(String name) {
        ArrayList applicationList;
        this.log.debug("findAll Application with name= {}", (Object)name);
        if (name == null || name.isEmpty()) {
            applicationList = this.loadConfigInfo(this.repository.findAll());
            applicationList = this.loadDeployInfo(applicationList);
        } else {
            Application application = this.repository.findByName(name.split("@")[0]);
            if (application == null) {
                application = new Application(name, Lists.newArrayList());
            }
            this.loadConfigInfo(application);
            this.loadDeployInfo(application);
            applicationList = Lists.newArrayList((Object[])new Application[]{application});
        }
        return applicationList;
    }

    public Collection<Application> getApplicationListByCluster(String cluster) {
        Collection serviceInfoList = Optional.ofNullable(this.serviceInfoRepository.getServiceInfoListByCluster(cluster)).orElse(new ArrayList());
        Collection serviceInfoNames = serviceInfoList.stream().map(s -> s.getName()).collect(Collectors.toList());
        Collection applications = Optional.ofNullable(this.repository.findAll()).orElse(new ArrayList());
        return applications.stream().filter(application -> serviceInfoNames.contains(application.getName())).collect(Collectors.toList());
    }

    public Collection<Instance> getInstanceListByCluster(String cluster) {
        Collection<Application> applicationList = this.getApplicationListByCluster(cluster);
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        for (Application application : applicationList) {
            instanceList.addAll(application.getInstances());
        }
        return instanceList;
    }

    public Instance findInstance(String id) {
        return this.repository.findInstance(id);
    }

    public String getInstanceManagementUrl(String id) {
        return this.repository.getInstanceManagementUrl(id);
    }

    public String proxy(String id, String method, ServletRequest request) throws Exception {
        return this.repository.proxy(id, method, request);
    }

    public String proxyPost(String id, String method, String body, HttpServletRequest request) throws Exception {
        return this.repository.proxyPost(id, method, body, request);
    }

    public String reStart(String instanceId) throws Exception {
        return this.repository.proxyPost(instanceId, "restart", null, null);
    }

    public String sendCmdStart(Instance instance) throws Exception {
        List<DeployInfo> deployList = this.dDeployRepository.getList();
        List tmp = deployList.stream().filter(a -> a.getIp().equals(instance.getIp()) && a.getPort() == instance.getPort()).collect(Collectors.toList());
        if (tmp.size() > 0) {
            DeployInfo deployInfo = (DeployInfo)tmp.get(0);
            return this.serviceInstall.sendCmdStart(deployInfo);
        }
        return "not DeployInfo,Start failed";
    }

    public String shutDown(String instanceId) throws Exception {
        return this.repository.proxyPost(instanceId, "shutdown", null, null);
    }
}

