/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ElasticsearchMetricsService {
    private final Logger logger = LoggerFactory.getLogger(ElasticsearchMetricsService.class);
    @Value(value="${elastic.kibana.api.url}")
    private String url;

    public String getAPMMetrics(int interval, String intervalType) {
        String requestJson = "{\"size\":0,\"query\":{\"range\":{\"@timestamp\":{\"gt\":\"now-" + interval + intervalType + "\"}}},\"aggs\":{\"apm-service\":{\"terms\":{\"field\":\"context.service.name\",\"order\":{\"transactions\":\"desc\"}},\"aggs\":{\"rt\":{\"avg\":{\"field\":\"transaction.duration.us\"}},\"rt_stats\":{\"extended_stats\":{\"field\":\"transaction.duration.us\"}},\"transactions\":{\"value_count\":{\"field\":\"transaction.id\"}},\"errors\":{\"value_count\":{\"field\":\"error.id\"}}}},\"apm-cluster-rt\":{\"avg\":{\"field\":\"transaction.duration.us\"}},\"apm-cluster-transactions\":{\"value_count\":{\"field\":\"transaction.id\"}},\"apm-cluster-errors\":{\"value_count\":{\"field\":\"error.id\"}}}}";
        return (String)this.excuteRestRequest("apm-*", requestJson).getBody();
    }

    public String getAPMMetricsWithMinute(int interval, String intervalType) {
        String intervalStr = "minute";
        String format = "hour_minute";
        if ("d".equals(intervalType)) {
            intervalStr = "day";
            format = "yyyy-MM-dd";
        } else if ("h".equals(intervalType)) {
            intervalStr = "hour";
        }
        String requestJson = "{\"size\":0,\"query\":{\"range\":{\"@timestamp\":{\"gt\":\"now-" + interval + intervalType + "\"}}},\"aggs\":{\"apm-minute\":{\"date_histogram\":{\"field\":\"@timestamp\",\"interval\":\"" + intervalStr + "\",\"format\":\"" + format + "\"},\"aggs\":{\"rt\":{\"avg\":{\"field\":\"transaction.duration.us\"}},\"errors\":{\"value_count\":{\"field\":\"error.id\"}},\"transactions\":{\"value_count\":{\"field\":\"transaction.id\"}}}}}}";
        return (String)this.excuteRestRequest("apm-*", requestJson).getBody();
    }

    public String getNodesMetrics(int interval, String intervalType) {
        String requestJson = "{\"size\":0,\"query\":{\"range\":{\"@timestamp\":{\"gt\":\"now-" + interval + intervalType + "\"}}},\"aggs\":{\"service-nodes\":{\"terms\":{\"field\":\"beat.name\"},\"aggs\":{\"cpu\":{\"avg\":{\"field\":\"system.cpu.user.pct\"}},\"memory\":{\"avg\":{\"field\":\"system.memory.actual.used.pct\"}},\"load-1\":{\"avg\":{\"field\":\"system.load.1\"}},\"load-5\":{\"avg\":{\"field\":\"system.load.5\"}},\"load-15\":{\"avg\":{\"field\":\"system.load.15\"}},\"disk-used\":{\"avg\":{\"field\":\"system.fsstat.total_size.used\"}},\"disk-total\":{\"avg\":{\"field\":\"system.fsstat.total_size.total\"}}}}}}";
        return (String)this.excuteRestRequest("metricbeat-*", requestJson).getBody();
    }

    private ResponseEntity<String> excuteRestRequest(String index, String requestJson) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("kbn-xsrf", "k");
        HttpEntity entity = new HttpEntity((Object)requestJson, (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.exchange(this.url + "&path=/" + index + "/_search", HttpMethod.POST, entity, String.class, new Object[0]);
        return response;
    }
}

