/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.service;

import cn.com.yusys.yusp.registry.governance.config.ServiceFileProperties;
import cn.com.yusys.yusp.registry.governance.domain.Application;
import cn.com.yusys.yusp.registry.governance.domain.DeployInfo;
import cn.com.yusys.yusp.registry.governance.domain.DeployInfoHistory;
import cn.com.yusys.yusp.registry.governance.domain.InstallInfo;
import cn.com.yusys.yusp.registry.governance.domain.Instance;
import cn.com.yusys.yusp.registry.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.registry.governance.domain.VersionInfo;
import cn.com.yusys.yusp.registry.governance.install.DeployStatus;
import cn.com.yusys.yusp.registry.governance.install.DeployUtil;
import cn.com.yusys.yusp.registry.governance.install.ServiceInstallBatch;
import cn.com.yusys.yusp.registry.governance.repository.ApplicationRepository;
import cn.com.yusys.yusp.registry.governance.repository.DeployHistoryRepository;
import cn.com.yusys.yusp.registry.governance.repository.DeployRepository;
import cn.com.yusys.yusp.registry.governance.repository.ServiceFlexHistoryRepository;
import cn.com.yusys.yusp.registry.governance.repository.ServiceInfoRepository;
import cn.com.yusys.yusp.registry.host.domain.HostDomain;
import cn.com.yusys.yusp.registry.host.repository.HostRepository;
import cn.com.yusys.yusp.registry.host.ssh.cmd.SimpleCmd;
import cn.com.yusys.yusp.registry.log.util.LogUtil;
import cn.com.yusys.yusp.registry.log.util.ModulNameConstant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Service;

@EnableConfigurationProperties(value={ServiceFileProperties.class})
@Service
public class ApplicationInstallService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationInstallService.class);
    private static final int DEFUALT_LOG_PAGESIZE = 2000;
    @Autowired
    HostRepository hostRepository;
    @Autowired
    ServiceFileProperties serviceFileProperties;
    @Autowired
    ServiceFlexHistoryRepository expandHistoryRepository;
    @Autowired
    ApplicationRepository applicationRepository;
    @Autowired
    DeployHistoryRepository deployHistoryRepository;
    @Autowired
    ServiceInstallBatch serviceInstallHolder;
    @Autowired
    DeployRepository deployRepository;
    @Autowired
    private ServiceInfoRepository serviceInfoRepository;

    public void install(VersionInfo versionInfo, List<HostDomain> hostDomainList) {
        this.serviceInstallHolder.installBatch(versionInfo, hostDomainList, ModulNameConstant.APPLICATION_INSTALL);
    }

    public void reInstall(VersionInfo versioninfo, List<Instance> instanceList) {
        LogUtil.info((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"\u91cd\u65b0\u90e8\u7f72->\u5f00\u59cb", (Object[])new Object[0]);
        if (instanceList == null) {
            return;
        }
        int total = instanceList.size();
        ArrayList<HostDomain> hostDomainList = new ArrayList<HostDomain>();
        LogUtil.info((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"\u505c\u5e94\u7528\u5f00\u59cb,\u5f85\u5904\u7406\u6570[{}]", (Object[])new Object[]{total});
        for (Instance instance : instanceList) {
            try {
                List hostTmp;
                LogUtil.info((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"\u5b9e\u4f8b[{}]\u5173\u95ed->\u5f00\u59cb", (Object[])new Object[]{instance.getIp()});
                String responseMsg = null;
                if (!instance.getStatus().equals(DeployStatus.OFFLINE.name())) {
                    responseMsg = this.shutDown(instance.getId());
                    LogUtil.info((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"\u5b9e\u4f8b[{}]\u5173\u95ed[{}]->{}", (Object[])new Object[]{instance.getIp(), responseMsg});
                }
                if ((hostTmp = this.hostRepository.getHostList().getHostDomains().stream().filter(host -> StringUtils.equalsIgnoreCase((String)host.getIp(), (String)instance.getIp())).collect(Collectors.toList())) == null || hostTmp.size() <= 0) continue;
                hostDomainList.add((HostDomain)hostTmp.get(0));
            }
            catch (Exception e) {
                e.printStackTrace();
                LogUtil.error((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"\u5b9e\u4f8b[{}]\u5173\u95ed[{}]\u5931\u8d25->{},\u6392\u9664\u90e8\u7f72", (Object[])new Object[]{instance.getIp(), e.getMessage()});
            }
        }
        LogUtil.info((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"\u505c\u5e94\u7528\u7ed3\u675f", (Object[])new Object[0]);
        this.install(versioninfo, hostDomainList);
        LogUtil.info((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"\u91cd\u65b0\u90e8\u7f72->\u7ed3\u675f", (Object[])new Object[0]);
    }

    public List<HostDomain> findUnUsedHostList(String name) {
        ArrayList<HostDomain> listHost = new ArrayList<HostDomain>();
        List<DeployInfo> listDeployInfo = this.deployRepository.getList();
        ServiceInfoDomain serviceDomain = this.serviceInfoRepository.getServiceInfoByName(name);
        for (HostDomain host : this.hostRepository.getHosts()) {
            if (!this.chkDomain(host, serviceDomain)) continue;
            Application application = this.applicationRepository.findByName(name);
            if (application != null && application.getInstances() != null) {
                DeployInfo delpoyInfo;
                List<Instance> instanceList = application.getInstances();
                int num = instanceList.stream().filter(ins -> StringUtils.equalsIgnoreCase((String)ins.getIp(), (String)host.getIp())).collect(Collectors.toList()).size();
                if (num > 0) {
                    log.info("\u5e94\u7528[{}],\u5df2\u90e8\u7f72\u4e3b\u673a[{}],\u7ee7\u7eed\u67e5\u627e", (Object)name, (Object)host.getIp());
                    continue;
                }
                List temp = listDeployInfo.stream().filter(a -> host.getHostName().equals(a.getHostName())).collect(Collectors.toList());
                if (temp.size() > 0 && StringUtils.isEmpty((String)(delpoyInfo = (DeployInfo)temp.get(0)).getEndTime())) {
                    log.info("\u4e3b\u673a[{}],\u672a\u5b8c\u6210\u7684\u90e8\u7f72[{}],\u90e8\u7f72\u65f6\u95f4[{}],\u7ee7\u7eed\u67e5\u627e", new Object[]{host.getIp(), delpoyInfo.getAppName(), delpoyInfo.getStartTime()});
                    continue;
                }
            }
            log.info("\u5e94\u7528[{}],\u672a\u90e8\u7f72\u4e3b\u673a[{}],\u53ef\u7528", (Object)name, (Object)host.getIp());
            listHost.add(host);
        }
        return listHost;
    }

    public List<HostDomain> findUnUsedHostListByCluster(String name, String cluster) {
        ArrayList<HostDomain> listHost = new ArrayList<HostDomain>();
        List<DeployInfo> listDeployInfo = this.deployRepository.getList();
        ServiceInfoDomain serviceDomain = this.serviceInfoRepository.getServiceInfoByName(name);
        for (HostDomain host : this.hostRepository.getHostListByCluster(cluster)) {
            if (!this.chkDomain(host, serviceDomain)) continue;
            Application application = this.applicationRepository.findByName(name);
            if (application != null && application.getInstances() != null) {
                DeployInfo delpoyInfo;
                List<Instance> instanceList = application.getInstances();
                int num = instanceList.stream().filter(ins -> StringUtils.equalsIgnoreCase((String)ins.getIp(), (String)host.getIp())).collect(Collectors.toList()).size();
                if (num > 0) {
                    log.info("\u5e94\u7528[{}],\u5df2\u90e8\u7f72\u4e3b\u673a[{}],\u7ee7\u7eed\u67e5\u627e", (Object)name, (Object)host.getIp());
                    continue;
                }
                List temp = listDeployInfo.stream().filter(a -> host.getHostName().equals(a.getHostName())).collect(Collectors.toList());
                if (temp.size() > 0 && StringUtils.isEmpty((String)(delpoyInfo = (DeployInfo)temp.get(0)).getEndTime())) {
                    log.info("\u4e3b\u673a[{}],\u672a\u5b8c\u6210\u7684\u90e8\u7f72[{}],\u90e8\u7f72\u65f6\u95f4[{}],\u7ee7\u7eed\u67e5\u627e", new Object[]{host.getIp(), delpoyInfo.getAppName(), delpoyInfo.getStartTime()});
                    continue;
                }
            }
            log.info("\u5e94\u7528[{}],\u672a\u90e8\u7f72\u4e3b\u673a[{}],\u53ef\u7528", (Object)name, (Object)host.getIp());
            listHost.add(host);
        }
        return listHost;
    }

    public boolean chkDomain(HostDomain hostDomain, ServiceInfoDomain serviceDomain) {
        if (hostDomain.getBusinessDomains() == null || hostDomain.getBusinessDomains().size() == 0) {
            return true;
        }
        return hostDomain.getBusinessDomains().contains(serviceDomain.getBusinessDomain());
    }

    public String shutDown(String instanceId) throws Exception {
        return this.applicationRepository.proxyPost(instanceId, "shutdown", null, null);
    }

    public List<DeployInfoHistory> queryHistory(String serviceName) {
        return this.deployHistoryRepository.getHistoryList().stream().filter(his -> StringUtils.equalsIgnoreCase((String)his.getName(), (String)serviceName)).sorted((s1, s2) -> s2.getOpDate().compareTo(s1.getOpDate())).collect(Collectors.toList());
    }

    public String queryStartLog(String hostName, String name, int startPage, int pageSize) {
        String result;
        HostDomain hostInfo = this.hostRepository.getHostByName(hostName);
        if (hostInfo == null) {
            return "";
        }
        if (startPage <= 0) {
            startPage = 1;
        }
        if (pageSize <= 0) {
            pageSize = 2000;
        }
        int headNum = startPage * pageSize;
        int tailNum = pageSize;
        String targetPath = DeployUtil.getTargetPath(hostInfo);
        try {
            result = this.hostRepository.goCmd(hostInfo.getHostName(), DeployUtil.getLogPath(targetPath), SimpleCmd.tailFile((int)headNum, (int)tailNum, (String)name)).getOut();
        }
        catch (Exception e) {
            result = "\u65e5\u5fd7\u52a0\u8f7d\u5f02\u5e38";
            e.printStackTrace();
        }
        return result;
    }

    public List<DeployInfo> queryDeployInfoList() {
        return this.deployRepository.getList();
    }

    public void remove(InstallInfo installInfo) throws Exception {
        for (Instance instance : installInfo.getInstanceList()) {
            LogUtil.info((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"\u5b9e\u4f8b\u79fb\u9664\uff0c\u5b9e\u4f8bNAME:[{}],URL:[{}]", (Object[])new Object[]{instance.getId(), instance.getUrl()});
            List<DeployInfo> depoyAll = this.deployRepository.getList();
            List depoyList = depoyAll.stream().filter(d -> d.getIp().equals(instance.getIp()) && d.getName().equals(instance.getId().split("@")[0])).collect(Collectors.toList());
            if (!instance.getStatus().equals(DeployStatus.OFFLINE.name())) {
                this.shutDown(instance.getId());
            }
            if (depoyList.size() <= 0) continue;
            DeployInfo deployInfo = (DeployInfo)depoyList.get(0);
            DeployInfoHistory deployInfoHistory = new DeployInfoHistory();
            this.deployRepository.remove(deployInfo);
            BeanUtils.copyProperties((Object)deployInfo, (Object)deployInfoHistory);
            deployInfoHistory.setUpdateTime(DateTime.now().toString("yyyy-MM-dd HH:mm:ss"));
            deployInfoHistory.setUpdateType("\u79fb\u9664");
            this.deployHistoryRepository.updateHistory(deployInfoHistory);
        }
    }
}

