/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.repository.eureka;

import cn.com.yusys.yusp.registry.governance.domain.Application;
import cn.com.yusys.yusp.registry.governance.domain.Instance;
import cn.com.yusys.yusp.registry.governance.repository.eureka.EurekaRepository;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class RemoteEurekaRepository
extends EurekaRepository {
    private EurekaClient eurekaClient;

    public RemoteEurekaRepository(Optional<EurekaClient> eurekaClient) {
        if (eurekaClient.isPresent()) {
            this.eurekaClient = eurekaClient.get();
        }
    }

    @Override
    public Collection<Application> findAll() {
        return this.eurekaClient.getApplications().getRegisteredApplications().stream().map(this.TO_APPLICATION).collect(Collectors.toList());
    }

    @Override
    public Application findByName(String name) {
        return (Application)this.TO_APPLICATION.apply(this.eurekaClient.getApplications().getRegisteredApplications(name));
    }

    @Override
    protected InstanceInfo findInstanceInfo(String id) {
        String[] instanceIds = id.split("@", 2);
        return this.eurekaClient.getApplication(instanceIds[0]).getByInstanceId(instanceIds[1].replaceAll("_", "."));
    }

    @Override
    public Collection<Instance> findAllInstance() {
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        Collection<Application> applicationList = this.findAll();
        for (Application application : applicationList) {
            instanceList.addAll(application.getInstances());
        }
        return instanceList;
    }

    @Override
    public String proxy(String id, String method, ServletRequest request) {
        return null;
    }

    @Override
    public String proxyPost(String id, String method, String body, HttpServletRequest request) {
        return null;
    }
}

