/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.repository.eureka;

import cn.com.yusys.yusp.registry.governance.domain.Application;
import cn.com.yusys.yusp.registry.governance.domain.Instance;
import cn.com.yusys.yusp.registry.governance.domain.InstanceHistory;
import cn.com.yusys.yusp.registry.governance.repository.RegistryRepository;
import cn.com.yusys.yusp.registry.governance.repository.eureka.EurekaRepository;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Pair;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class LocaleEurekaRepository
extends EurekaRepository
implements RegistryRepository {
    private final Logger log = LoggerFactory.getLogger(LocaleEurekaRepository.class);
    private final PeerAwareInstanceRegistry registry;
    private final HttpClient httpClient;
    private Function<Pair<Long, String>, InstanceHistory> TO_REGISTRY_HISTORY = history -> new InstanceHistory((String)history.second(), new Date((Long)history.first()));

    public LocaleEurekaRepository(PeerAwareInstanceRegistry registry, HttpClient httpClient) {
        this.registry = registry;
        this.httpClient = httpClient;
    }

    @Override
    public Collection<Application> findAll() {
        return this.registry.getSortedApplications().stream().map(this.TO_APPLICATION).collect(Collectors.toList());
    }

    @Override
    public Application findByName(String name) {
        return (Application)this.TO_APPLICATION.apply(this.registry.getApplication(name));
    }

    @Override
    public List<InstanceHistory> getCanceledInstanceHistory() {
        return this.registry.getLastNCanceledInstances().stream().map(this.TO_REGISTRY_HISTORY).collect(Collectors.toList());
    }

    @Override
    public List<InstanceHistory> getRegisteredInstanceHistory() {
        return this.registry.getLastNRegisteredInstances().stream().map(this.TO_REGISTRY_HISTORY).collect(Collectors.toList());
    }

    @Override
    protected InstanceInfo findInstanceInfo(String id) {
        String[] instanceIds = id.split("@", 2);
        this.log.info("instanceIds:{}, splitChar:{}", (Object)id, (Object)"@");
        return this.registry.getInstanceByAppAndId(instanceIds[0], instanceIds[1].replaceAll("_", "."));
    }

    @Override
    public Collection<Instance> findAllInstance() {
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        Collection<Application> applicationList = this.findAll();
        for (Application application : applicationList) {
            instanceList.addAll(application.getInstances());
        }
        return instanceList;
    }

    @Override
    public String proxy(String id, String method, ServletRequest request) throws Exception {
        String managementUrl = this.getInstanceManagementUrl(id);
        String url = managementUrl + "/" + method;
        try {
            URIBuilder builder = new URIBuilder(url);
            if (request != null) {
                request.getParameterMap().forEach((key, value) -> builder.setParameter(key, value[0]));
            }
            HttpGet httpGet = new HttpGet(builder.build());
            this.log.info("\u8c03\u7528\u5b9e\u4f8b[{}],API[{}],{}", new Object[]{id, url, "HttpGet"});
            HttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            return result;
        }
        catch (Exception e) {
            this.log.error("\u8c03\u7528\u5b9e\u4f8b[{}],API[{}],{}", new Object[]{id, url, e.getMessage()});
            throw e;
        }
    }

    @Override
    public String proxyPost(String id, String method, String body, HttpServletRequest request) throws Exception {
        String managementUrl = this.getInstanceManagementUrl(id);
        String url = managementUrl + "/" + method;
        try {
            URIBuilder builder = new URIBuilder(url);
            HttpPost post = new HttpPost(builder.build());
            if (request != null) {
                request.getParameterMap().forEach((key, value) -> builder.setParameter(key, value[0]));
            }
            if (body != null) {
                post.setEntity((HttpEntity)new StringEntity(body));
            }
            this.log.info("\u8c03\u7528\u5b9e\u4f8b[{}],API[{}],{}", new Object[]{id, url, "HttpPost"});
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            this.log.info("\u8c03\u7528\u5b9e\u4f8b[{}],API[{}]", (Object)id, (Object)url);
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            this.log.error("\u8c03\u7528\u5b9e\u4f8b[{}],API[{}],{}", new Object[]{id, url, e.getMessage()});
            throw e;
        }
    }
}

