/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.repository.eureka;

import cn.com.yusys.yusp.registry.governance.domain.Instance;
import cn.com.yusys.yusp.registry.governance.repository.ApplicationRepository;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public abstract class EurekaRepository
implements ApplicationRepository {
    private final Logger log = LoggerFactory.getLogger(EurekaRepository.class);
    public static final String INS_NAME_SPLIT_CHAR = "@";
    public static final String DEFAULT_MANAGEMENT_PATH_KEY = "managementPath";
    public static final String DEFAULT_MANAGEMENT_PATH_VALUE = "management";
    public static final String DEFAULT_MANAGEMENT_RESTART = "restart";
    public static final String DEFAULT_MANAGEMENT_SHUTDOWN = "shutdown";
    @Value(value="${spring.cloud.dashboard.turbine.url:http://localhost:${server.port}/turbine.stream}")
    private String turbineUrl;
    protected Function<Application, cn.com.yusys.yusp.registry.governance.domain.Application> TO_APPLICATION = new Function<Application, cn.com.yusys.yusp.registry.governance.domain.Application>(){

        @Override
        public cn.com.yusys.yusp.registry.governance.domain.Application apply(Application app) {
            if (app == null) {
                return null;
            }
            return new cn.com.yusys.yusp.registry.governance.domain.Application(app.getName(), app.getInstances().stream().map(EurekaRepository.this.TO_INSTANCE).sorted((o1, o2) -> o1.getName().compareTo(o2.getName())).collect(Collectors.toList()));
        }
    };
    protected Function<InstanceInfo, Instance> TO_INSTANCE = instance -> {
        if (instance == null) {
            return null;
        }
        String version = (String)instance.getMetadata().get("subversion");
        if (StringUtils.isEmpty((CharSequence)version)) {
            version = (String)instance.getMetadata().get("version");
        }
        return new Instance(instance.getHomePageUrl(), instance.getId(), instance.getAppName() + INS_NAME_SPLIT_CHAR + instance.getId().replaceAll("\\.", "_"), instance.getStatus().toString(), version, "");
    };

    @Override
    public abstract cn.com.yusys.yusp.registry.governance.domain.Application findByName(String var1);

    @Override
    public String getApplicationCircuitBreakerStreamUrl(String name) {
        if (this.findByName(name) == null) {
            return null;
        }
        return this.turbineUrl + "?cluster=" + name;
    }

    @Override
    public String getInstanceCircuitBreakerStreamUrl(String instanceId) {
        String url = this.getInstanceManagementUrl(instanceId);
        if (url == null) {
            return null;
        }
        return url + "/hystrix.stream";
    }

    @Override
    public Instance findInstance(String id) {
        return this.TO_INSTANCE.apply(this.findInstanceInfo(id));
    }

    @Override
    public String getInstanceManagementUrl(String id) {
        String[] tmp;
        InstanceInfo info = this.findInstanceInfo(id);
        if (info == null) {
            this.log.info("info is null");
            return null;
        }
        String url = info.getHomePageUrl();
        if (info.getMetadata().containsKey(DEFAULT_MANAGEMENT_PATH_KEY)) {
            url = url + (String)info.getMetadata().get(DEFAULT_MANAGEMENT_PATH_KEY);
        } else if (info.getHealthCheckUrl() != null && info.getHealthCheckUrl().indexOf(DEFAULT_MANAGEMENT_PATH_VALUE) > 0) {
            url = url + DEFAULT_MANAGEMENT_PATH_VALUE;
        } else if (info.getHealthCheckUrl() != null && (tmp = info.getHealthCheckUrl().split("/")) != null && tmp.length >= 5 && "health".equals(tmp[4])) {
            url = url + tmp[3];
        }
        return url;
    }

    protected abstract InstanceInfo findInstanceInfo(String var1);
}

