/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.repository;

import cn.com.yusys.yusp.registry.governance.domain.WarnRule;
import cn.com.yusys.yusp.registry.host.config.CommonProperties;
import cn.com.yusys.yusp.registry.host.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.registry.host.exception.DashboardFileException;
import cn.com.yusys.yusp.registry.host.exception.DashboardParamException;
import cn.com.yusys.yusp.registry.host.repository.CommonRepository;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Repository;

@Repository
@EnableConfigurationProperties(value={ConfigFileConfiguration.class})
public class WarnRuleRepository
extends CommonRepository {
    private final Logger log = LoggerFactory.getLogger(WarnRuleRepository.class);

    public WarnRuleRepository(ConfigFileConfiguration properties) {
        super((CommonProperties)properties.getRegistryStore());
    }

    public JavaType getJavaType() {
        TypeFactory factory = TypeFactory.defaultInstance();
        return factory.constructParametricType(List.class, new Class[]{WarnRule.class});
    }

    public List<WarnRule> getList() {
        ArrayList warnRuleList = (ArrayList)this.getLoadObj();
        if (warnRuleList == null) {
            warnRuleList = new ArrayList();
        }
        return warnRuleList;
    }

    public void update(WarnRule warnRule) throws DashboardParamException, DashboardFileException {
        List<WarnRule> warnRuleList = this.getList();
        boolean updateStatus = false;
        for (WarnRule inst : warnRuleList) {
            if (!inst.getId().equals(warnRule.getId())) continue;
            this.log.info("inst.name:{}, warnRule.name:{}", (Object)inst.getName(), (Object)warnRule.getName());
            BeanUtils.copyProperties((Object)warnRule, (Object)inst);
            updateStatus = true;
        }
        if (!updateStatus) {
            warnRuleList.add(warnRule);
        }
        try {
            this.getAfo().writeObject(warnRuleList);
        }
        catch (DashboardFileException e) {
            if (updateStatus) {
                this.log.error("\u66f4\u65b0\u9884\u8b66\u89c4\u5219\u5931\u8d25: " + warnRule + " error:" + e.getMessage());
            } else {
                this.log.error("\u65b0\u589e\u9884\u8b66\u89c4\u5219\u5931\u8d25: " + warnRule + " error:" + e.getMessage());
            }
            throw e;
        }
    }

    public void delete(String ids) throws DashboardParamException {
        List<String> idList = Arrays.asList(ids.split(","));
        List<WarnRule> warnRuleList = this.getList();
        ArrayList<WarnRule> removeList = null;
        for (WarnRule inst : warnRuleList) {
            if (!idList.contains(inst.getId())) continue;
            if (removeList == null) {
                removeList = new ArrayList<WarnRule>();
            }
            removeList.add(inst);
        }
        if (removeList == null) {
            return;
        }
        warnRuleList.removeAll(removeList);
        try {
            this.getAfo().writeObject(warnRuleList);
        }
        catch (DashboardFileException e) {
            this.log.error("\u5220\u9664\u9884\u8b66\u89c4\u5219\u9519\u8bef ids:" + ids + " error:" + e.getMessage());
            e.printStackTrace();
        }
    }
}

