/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.repository;

import cn.com.yusys.yusp.registry.governance.domain.WarnRuleHistory;
import cn.com.yusys.yusp.registry.host.config.CommonProperties;
import cn.com.yusys.yusp.registry.host.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.registry.host.exception.DashboardFileException;
import cn.com.yusys.yusp.registry.host.exception.DashboardParamException;
import cn.com.yusys.yusp.registry.host.repository.CommonRepository;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Repository;

@Repository
@EnableConfigurationProperties(value={ConfigFileConfiguration.class})
public class WarnRuleHistoryRepository
extends CommonRepository {
    private final Logger log = LoggerFactory.getLogger(WarnRuleHistoryRepository.class);

    public WarnRuleHistoryRepository(ConfigFileConfiguration properties) {
        super((CommonProperties)properties.getWarnHistoryLog());
    }

    public JavaType getJavaType() {
        TypeFactory factory = TypeFactory.defaultInstance();
        return factory.constructParametricType(List.class, new Class[]{WarnRuleHistory.class});
    }

    public List<WarnRuleHistory> getList() {
        ArrayList<WarnRuleHistory> histories = (ArrayList<WarnRuleHistory>)this.getLoadObj();
        if (histories == null) {
            histories = new ArrayList<WarnRuleHistory>();
        }
        Collections.sort(histories, new Comparator<WarnRuleHistory>(){

            @Override
            public int compare(WarnRuleHistory o1, WarnRuleHistory o2) {
                Date time1 = o1.getTime();
                Date time2 = o2.getTime();
                if (time1 != null && time2 != null) {
                    return time1.getTime() >= time2.getTime() ? -1 : 1;
                }
                return 0;
            }
        });
        return histories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndUpdate(WarnRuleHistory warnRuleHistory) throws Exception {
        WarnRuleHistoryRepository warnRuleHistoryRepository = this;
        synchronized (warnRuleHistoryRepository) {
            List<WarnRuleHistory> histories = this.getList();
            boolean updateStatus = false;
            for (WarnRuleHistory history : histories) {
                if (!history.getId().equals(warnRuleHistory.getId())) continue;
                BeanUtils.copyProperties((Object)warnRuleHistory, (Object)history);
                updateStatus = true;
            }
            if (!updateStatus) {
                histories.add(warnRuleHistory);
            }
            try {
                this.getAfo().writeObject(histories);
            }
            catch (Exception e) {
                this.log.error("\u6dfb\u52a0\u9884\u8b66\u5386\u53f2\u7eaa\u5f55\u5931\u8d25: " + warnRuleHistory + "  error:" + e.getMessage());
                throw e;
            }
        }
    }

    public void delete(String ids) throws DashboardParamException {
        List<String> idList = Arrays.asList(ids.split(","));
        List<WarnRuleHistory> histories = this.getList();
        ArrayList<WarnRuleHistory> removeList = null;
        for (WarnRuleHistory inst : histories) {
            if (!idList.contains(inst.getId())) continue;
            if (removeList == null) {
                removeList = new ArrayList<WarnRuleHistory>();
            }
            removeList.add(inst);
        }
        if (removeList == null) {
            return;
        }
        histories.removeAll(removeList);
        try {
            this.getAfo().writeObject(histories);
        }
        catch (DashboardFileException e) {
            this.log.error("\u5220\u9664\u9884\u8b66\u5386\u53f2 ids:" + ids + " error:" + e.getMessage());
            e.printStackTrace();
        }
    }
}

