/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.repository;

import cn.com.yusys.yusp.registry.governance.config.ServiceFileProperties;
import cn.com.yusys.yusp.registry.governance.domain.IndexDomain;
import cn.com.yusys.yusp.registry.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.registry.governance.domain.ServiceInfoDomainList;
import cn.com.yusys.yusp.registry.governance.domain.ServiceLimitDomain;
import cn.com.yusys.yusp.registry.governance.domain.VersionInfo;
import cn.com.yusys.yusp.registry.host.config.CommonProperties;
import cn.com.yusys.yusp.registry.host.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.registry.host.repository.CommonRepository;
import cn.com.yusys.yusp.registry.host.ssh.Utils;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Repository;

@EnableConfigurationProperties(value={ConfigFileConfiguration.class})
@Repository
public class ServiceInfoRepository
extends CommonRepository {
    private final Logger logger = LoggerFactory.getLogger(ServiceInfoRepository.class);
    @Autowired
    private ServiceFileProperties serviceFileProperties;

    public ServiceInfoRepository(ConfigFileConfiguration properties) {
        super((CommonProperties)properties.getRegistryStore());
    }

    public ServiceInfoDomainList getServiceInfoList() {
        ServiceInfoDomainList infoList = (ServiceInfoDomainList)this.getLoadObj();
        if (infoList == null) {
            infoList = new ServiceInfoDomainList();
        }
        if (infoList.getServiceInfos() == null) {
            infoList.setServiceInfos(new ArrayList<ServiceInfoDomain>());
        }
        return infoList;
    }

    public List<ServiceInfoDomain> getServiceInfoListByCluster(String cluster) {
        ServiceInfoDomainList infoList = (ServiceInfoDomainList)this.getLoadObj();
        if (infoList == null) {
            infoList = new ServiceInfoDomainList();
            infoList.setServiceInfos(new ArrayList<ServiceInfoDomain>());
            return infoList.getServiceInfos();
        }
        ServiceInfoDomainList resultServiceDomainList = new ServiceInfoDomainList();
        ArrayList<ServiceInfoDomain> temp = new ArrayList<ServiceInfoDomain>();
        for (ServiceInfoDomain serviceInfoDomain : infoList.getServiceInfos()) {
            if (!serviceInfoDomain.getClusters().contains(cluster)) continue;
            temp.add(serviceInfoDomain);
        }
        resultServiceDomainList.setServiceInfos(temp);
        return resultServiceDomainList.getServiceInfos();
    }

    public List<ServiceInfoDomain> getServiceInfos() {
        return this.getServiceInfoList().getServiceInfos();
    }

    public ServiceInfoDomain getServiceInfoByName(String name) {
        ServiceInfoDomain info = null;
        for (ServiceInfoDomain serviceInfo : this.getServiceInfos()) {
            if (!StringUtils.equals((CharSequence)name, (CharSequence)serviceInfo.getName())) continue;
            info = serviceInfo;
            break;
        }
        if (info == null) {
            info = new ServiceInfoDomain();
        }
        return info;
    }

    public int updateService(ServiceInfoDomain domain, boolean merge) {
        ServiceInfoDomainList domainList = this.getServiceInfoList();
        List<ServiceInfoDomain> infoDomainList = this.getServiceInfos();
        boolean success = true;
        try {
            Field field = domain.getClass().getDeclaredField("id");
            success = this.updateList(infoDomainList, domain, field, merge);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        if (!success) {
            return 1;
        }
        domainList.setServiceInfos(infoDomainList);
        return this.writeObject(domainList);
    }

    public int updateExpandShrinkDetails(ServiceInfoDomain domain, boolean merge) {
        ServiceInfoDomainList domainList = this.getServiceInfoList();
        List<ServiceInfoDomain> infoDomainList = this.getServiceInfos();
        for (ServiceInfoDomain serviceInfoDomain : infoDomainList) {
            if (!serviceInfoDomain.getName().equals(domain.getName())) continue;
            serviceInfoDomain.setExpandMax(domain.getExpandMax());
            serviceInfoDomain.setExpandShrinkFrequency(domain.getExpandShrinkFrequency());
            serviceInfoDomain.setExpandShrinkStrategy(domain.getExpandShrinkStrategy());
            serviceInfoDomain.setShrinkMin(domain.getShrinkMin());
            domain.setId(serviceInfoDomain.getId());
        }
        boolean success = true;
        try {
            Field field = domain.getClass().getDeclaredField("id");
            success = this.updateList(infoDomainList, domain, field, merge);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        if (!success) {
            return 1;
        }
        domainList.setServiceInfos(infoDomainList);
        return this.writeObject(domainList);
    }

    public int removeService(String ids) {
        String[] strings;
        ServiceInfoDomainList domainList = this.getServiceInfoList();
        List<ServiceInfoDomain> infoDomainList = this.getServiceInfos();
        block0: for (String s : strings = ids.split(",")) {
            Iterator<ServiceInfoDomain> iterator = infoDomainList.iterator();
            while (iterator.hasNext()) {
                ServiceInfoDomain domain = iterator.next();
                if (!StringUtils.equals((CharSequence)domain.getId(), (CharSequence)s)) continue;
                String serviceName = domain.getName();
                this.logger.info("\u79fb\u9664\u670d\u52a1:{}", (Object)serviceName);
                if (this.removeVersion(serviceName, null) != 1) {
                    return 1;
                }
                iterator.remove();
                continue block0;
            }
        }
        domainList.setServiceInfos(infoDomainList);
        return this.writeObject(domainList);
    }

    public List<IndexDomain> getIndexByName(String name) {
        this.logger.info("\u83b7\u53d6\u670d\u52a1:{}\u7684\u6307\u6807\u96c6");
        List<Object> indexDomains = null;
        ServiceInfoDomainList infoList = this.getServiceInfoList();
        for (ServiceInfoDomain info : infoList.getServiceInfos()) {
            if (!StringUtils.equals((CharSequence)name, (CharSequence)info.getName())) continue;
            indexDomains = info.getIndexDomains();
        }
        if (indexDomains == null) {
            indexDomains = new ArrayList();
        }
        return indexDomains;
    }

    public int updateServiceIndex(String name, IndexDomain indexDomain, boolean merge) {
        this.logger.info("\u53d8\u66f4\u670d\u52a1:{}\u7684\u6307\u6807\u96c6:{}", (Object)name, (Object)indexDomain);
        if (StringUtils.isNotEmpty((CharSequence)name) && indexDomain != null && indexDomain.validate()) {
            if (StringUtils.isEmpty((CharSequence)indexDomain.getId())) {
                indexDomain.setId(Utils.getUuid());
            }
            ServiceInfoDomain serviceInfoDomain = this.getServiceInfoByName(name);
            serviceInfoDomain.setAutoExpand(true);
            serviceInfoDomain.setIndexDomains(this.updateIndexList(this.getIndexByName(name), indexDomain, merge));
            return this.updateService(serviceInfoDomain, merge);
        }
        return 1;
    }

    private List<IndexDomain> updateIndexList(List<IndexDomain> indexDomainList, IndexDomain indexDomain, boolean merge) {
        try {
            Field field = indexDomain.getClass().getDeclaredField("id");
            this.updateList(indexDomainList, indexDomain, field, merge);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return indexDomainList;
    }

    public int removeServiceIndex(String name, String[] keys) {
        this.logger.info("\u5220\u9664\u670d\u52a1:{}\u7684\u6307\u6807:{}", (Object)name, (Object)keys);
        if (StringUtils.isNotEmpty((CharSequence)name) && StringUtils.isNoneEmpty((CharSequence[])keys)) {
            try {
                ServiceInfoDomain serviceInfoDomain = this.getServiceInfoByName(name);
                List<IndexDomain> list = this.getIndexByName(name);
                Field field = IndexDomain.class.getDeclaredField("id");
                this.removeByKeys(list, field, keys);
                serviceInfoDomain.setIndexDomains(list);
                if (list.isEmpty()) {
                    serviceInfoDomain.setAutoExpand(false);
                }
                return this.updateService(serviceInfoDomain, true);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return 1;
    }

    public Map<String, VersionInfo> getVersionByName(String name) {
        ServiceInfoDomain domain = this.getServiceInfoByName(name);
        if (domain.getVersionMap() == null) {
            domain.setVersionMap(new HashMap<String, VersionInfo>());
        }
        return domain.getVersionMap();
    }

    public VersionInfo getMaxVersionByName(String name) {
        List<VersionInfo> fileList = this.getServiceBasicInfo(name);
        VersionInfo versionInfo = null;
        if (fileList != null && !fileList.isEmpty()) {
            versionInfo = (VersionInfo)fileList.stream().sorted((s1, s2) -> s2.getVersion().compareTo(s1.getVersion())).collect(Collectors.toList()).get(0);
        }
        return versionInfo;
    }

    public int updateVersion(String name, VersionInfo versionInfo, boolean merge, boolean delete) {
        ServiceInfoDomain domain = this.getServiceInfoByName(name);
        Map<String, VersionInfo> versionMap = this.getVersionByName(name);
        if (delete) {
            versionMap.remove(versionInfo.getVersion());
        } else {
            if (merge && !this.merge(versionInfo, versionMap.get(versionInfo.getVersion()))) {
                return 1;
            }
            versionMap.put(versionInfo.getVersion(), versionInfo);
        }
        domain.setVersionMap(versionMap);
        return this.updateService(domain, merge);
    }

    public int removeVersion(String serviceName, String fileList) {
        int success = 1;
        if (StringUtils.isNotEmpty((CharSequence)serviceName)) {
            File[] files;
            String path = this.serviceFileProperties.getPath(serviceName);
            File dirFile = new File(path);
            if (!dirFile.exists()) {
                this.logger.info("\u670d\u52a1:{}\u7684\u7248\u672c\u6587\u4ef6\u5939\u4e0d\u5b58\u5728", (Object)serviceName);
                return success;
            }
            if (StringUtils.isNotEmpty((CharSequence)fileList)) {
                String[] files2;
                for (String file : files2 = fileList.split(",")) {
                    File tempfile = new File(path + file);
                    if (tempfile.exists()) {
                        if (tempfile.delete()) {
                            this.logger.info("\u79fb\u9664\u670d\u52a1:{}\u7684\u7248\u672c:{},\u6210\u529f", (Object)serviceName, (Object)file);
                            continue;
                        }
                        this.logger.info("\u79fb\u9664\u670d\u52a1:{}\u7684\u7248\u672c:{},\u5931\u8d25", (Object)serviceName, (Object)file);
                        return 1;
                    }
                    this.logger.info("\u670d\u52a1:{}\u7684\u7248\u672c:{}\u4e0d\u5b58\u5728", (Object)serviceName, (Object)file);
                }
                return success;
            }
            for (File file : files = dirFile.listFiles()) {
                if (file.exists()) {
                    if (file.delete()) {
                        this.logger.info("\u79fb\u9664\u670d\u52a1:{}\u7684\u7248\u672c:{},\u6210\u529f", (Object)serviceName, (Object)file.getName());
                        continue;
                    }
                    this.logger.info("\u79fb\u9664\u670d\u52a1:{}\u7684\u7248\u672c:{},\u5931\u8d25", (Object)serviceName, (Object)file.getName());
                    return 1;
                }
                this.logger.info("\u670d\u52a1:{}\u7684\u7248\u672c:{}\u4e0d\u5b58\u5728", (Object)serviceName, (Object)file.getName());
            }
            if (dirFile.delete()) {
                this.logger.info("\u79fb\u9664\u670d\u52a1:{}\u6587\u4ef6\u5939,\u6210\u529f", (Object)serviceName);
                return success;
            }
            return 1;
        }
        return 1;
    }

    public List<ServiceLimitDomain> getLimitByName(String name) {
        ServiceInfoDomain s = this.getServiceInfoByName(name);
        if (s != null) {
            if (s.getLimitDomains() != null) {
                return s.getLimitDomains();
            }
            return new ArrayList<ServiceLimitDomain>();
        }
        return new ArrayList<ServiceLimitDomain>();
    }

    public int upadteLimter(String name, ServiceLimitDomain limitDomain, boolean merge, boolean delete) {
        ServiceInfoDomain serviceInfoDomain = this.getServiceInfoByName(name);
        if (serviceInfoDomain == null) {
            serviceInfoDomain = new ServiceInfoDomain();
            serviceInfoDomain.setName(name);
            serviceInfoDomain.setId(name);
        } else if (serviceInfoDomain.getId() == null) {
            serviceInfoDomain.setId(name);
            serviceInfoDomain.setName(name);
        }
        serviceInfoDomain.setLimitDomains(this.updateLimitList(this.getLimitByName(name), limitDomain, merge, delete));
        return this.updateService(serviceInfoDomain, merge);
    }

    private List<ServiceLimitDomain> updateLimitList(List<ServiceLimitDomain> limitDomains, ServiceLimitDomain limitDomain, boolean merge, boolean delete) {
        try {
            Field compare = limitDomain.getClass().getDeclaredField("limitMode");
            this.updateList(limitDomains, limitDomain, compare, merge);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return limitDomains;
    }

    public int saveNodeInfo(String coordinate, boolean merge) {
        List nodeInfoList = null;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Map contentMap = (Map)objectMapper.readValue(coordinate, Map.class);
            String content = (String)contentMap.get("coordinate");
            nodeInfoList = (List)objectMapper.readValue(content, List.class);
            int len = nodeInfoList.size();
            for (int i = 0; i < len; ++i) {
                Map map = (Map)nodeInfoList.get(i);
                ServiceInfoDomain serviceInfoDomain = this.getServiceInfoByName(map.get("nodeName").toString());
                serviceInfoDomain.setOffsetX(map.get("offsetX").toString());
                serviceInfoDomain.setOffsetY(map.get("offsetY").toString());
                this.updateService(serviceInfoDomain, merge);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    public List<VersionInfo> getFileByServiceName(String serviceName) {
        ArrayList<VersionInfo> fileNameList = new ArrayList<VersionInfo>();
        String folderPath = this.serviceFileProperties.getPath(serviceName);
        File directory = new File(folderPath);
        if (!directory.exists()) {
            return new ArrayList<VersionInfo>();
        }
        if (directory.isDirectory()) {
            File[] filelist = directory.listFiles();
            for (int i = 0; i < filelist.length; ++i) {
                if (filelist[i].isDirectory()) continue;
                VersionInfo versionInfo = new VersionInfo();
                String fileName = filelist[i].getName();
                versionInfo.setFileName(fileName);
                fileNameList.add(versionInfo);
            }
        }
        return fileNameList;
    }

    public List<VersionInfo> getServiceBasicInfo(String serviceName) {
        ArrayList<VersionInfo> serviceBasicInfoList = new ArrayList<VersionInfo>();
        List<VersionInfo> versionList = this.getFileByServiceName(serviceName);
        if (versionList != null && !versionList.isEmpty()) {
            for (VersionInfo version : versionList) {
                VersionInfo versionInfo = new VersionInfo();
                String fileName = version.getFileName();
                String[] nameSplit = fileName.split("_");
                String versionNo = nameSplit[0];
                versionInfo.setName(serviceName);
                versionInfo.setVersion(versionNo);
                versionInfo.setFileName(fileName);
                serviceBasicInfoList.add(versionInfo);
            }
        }
        return serviceBasicInfoList;
    }

    public JavaType getJavaType() {
        return TypeFactory.defaultInstance().constructType(ServiceInfoDomainList.class);
    }
}

