/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.repository;

import cn.com.yusys.yusp.registry.governance.domain.ServiceFlexHistory;
import cn.com.yusys.yusp.registry.host.config.CommonProperties;
import cn.com.yusys.yusp.registry.host.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.registry.host.repository.CommonRepository;
import cn.com.yusys.yusp.registry.host.ssh.Utils;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Repository;

@EnableConfigurationProperties(value={ConfigFileConfiguration.class})
@Repository
public class ServiceFlexHistoryRepository
extends CommonRepository {
    private Logger logger = LoggerFactory.getLogger(ServiceFlexHistoryRepository.class);
    private JavaType javaType;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ServiceFlexHistoryRepository(ConfigFileConfiguration properties) {
        super((CommonProperties)properties.getFlexHistory());
    }

    public JavaType getJavaType() {
        if (this.javaType == null) {
            TypeFactory factory = TypeFactory.defaultInstance();
            JavaType keyType = factory.constructType(String.class);
            JavaType valueType = factory.constructParametricType(List.class, new Class[]{ServiceFlexHistory.class});
            this.javaType = factory.constructMapType(Map.class, keyType, valueType);
        }
        return this.javaType;
    }

    public Map<String, List<ServiceFlexHistory>> getFlexHistory() {
        HashMap map = (HashMap)this.getLoadObj();
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    public List<ServiceFlexHistory> getFlexHistoryByName(String name) {
        this.logger.info("\u83b7\u53d6\u670d\u52a1:{}\u7684\u4f38\u7f29\u5386\u53f2", (Object)name);
        List<ServiceFlexHistory> list = this.getFlexHistory().get(name);
        if (list == null) {
            list = new ArrayList<ServiceFlexHistory>();
        } else {
            Collections.sort(list, new Comparator<ServiceFlexHistory>(){

                @Override
                public int compare(ServiceFlexHistory o1, ServiceFlexHistory o2) {
                    Date time1 = null;
                    Date time2 = null;
                    try {
                        time1 = ServiceFlexHistoryRepository.this.sdf.parse(o1.getTime());
                        time2 = ServiceFlexHistoryRepository.this.sdf.parse(o2.getTime());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (time1 != null && time2 != null) {
                        return time1.getTime() > time2.getTime() ? -1 : 1;
                    }
                    return 0;
                }
            });
        }
        return list;
    }

    public int addFlexHitory(String name, ServiceFlexHistory history) {
        this.logger.info("\u670d\u52a1:{}\u6dfb\u52a0\u4f38\u7f29\u5386\u53f2 :{}", (Object)name, (Object)history);
        if (StringUtils.isNotEmpty((CharSequence)name) && history != null) {
            if (StringUtils.isEmpty((CharSequence)history.getId())) {
                history.setId(Utils.getUuid());
            }
            Map<String, List<ServiceFlexHistory>> map = this.getFlexHistory();
            List<ServiceFlexHistory> list = this.getFlexHistoryByName(name);
            list.add(history);
            map.put(name, list);
            return this.writeObject(map);
        }
        return 1;
    }
}

