/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.repository;

import cn.com.yusys.yusp.registry.governance.domain.ServiceDegradationDomain;
import cn.com.yusys.yusp.registry.governance.domain.ServiceDegradationList;
import cn.com.yusys.yusp.registry.host.config.CommonProperties;
import cn.com.yusys.yusp.registry.host.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.registry.host.exception.DashboardFileException;
import cn.com.yusys.yusp.registry.host.repository.CommonRepository;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Repository;

@EnableConfigurationProperties(value={ConfigFileConfiguration.class})
@Repository
public class ServiceDegradationRepository
extends CommonRepository {
    private final Logger log = LoggerFactory.getLogger(ServiceDegradationRepository.class);

    public ServiceDegradationRepository(ConfigFileConfiguration properties) {
        super((CommonProperties)properties.getRegistryStore());
    }

    public JavaType getJavaType() {
        return TypeFactory.defaultInstance().constructType(ServiceDegradationList.class);
    }

    public List<ServiceDegradationDomain> getServiceDegradationList() {
        List<Object> serviceDegradationList = null;
        serviceDegradationList = this.getLoadObj() != null ? ((ServiceDegradationList)this.getLoadObj()).getServiceDegradationList() : new ArrayList();
        return serviceDegradationList;
    }

    public List<ServiceDegradationDomain> getServiceDegradation(String name) {
        List<ServiceDegradationDomain> serviceDegradationList;
        ArrayList<ServiceDegradationDomain> dl = new ArrayList<ServiceDegradationDomain>();
        if (this.getLoadObj() != null && (serviceDegradationList = ((ServiceDegradationList)this.getLoadObj()).getServiceDegradationList()) != null) {
            for (ServiceDegradationDomain d : serviceDegradationList) {
                if (!d.getName().equals(name)) continue;
                dl.add(d);
            }
        }
        return dl;
    }

    public int updateServiceDegradation(ServiceDegradationDomain serviceDegradationDomain) {
        List<ServiceDegradationDomain> serviceDegradationList = null;
        ServiceDegradationList serviceDegradationListObj = null;
        serviceDegradationListObj = (ServiceDegradationList)this.getLoadObj();
        if (serviceDegradationListObj != null) {
            serviceDegradationList = serviceDegradationListObj.getServiceDegradationList();
            if (serviceDegradationList != null) {
                if (serviceDegradationList.contains(serviceDegradationDomain)) {
                    int index = serviceDegradationList.indexOf(serviceDegradationDomain);
                    if (index >= 0) {
                        ServiceDegradationDomain d = serviceDegradationList.get(index);
                        d.setStaticResContent(serviceDegradationDomain.getStaticResContent());
                        d.setDowngradeStrategy(serviceDegradationDomain.getDowngradeStrategy());
                        d.setStaticResContentType(serviceDegradationDomain.getStaticResContentType());
                        d.setUri(serviceDegradationDomain.getUri());
                    }
                } else {
                    serviceDegradationList.add(0, serviceDegradationDomain);
                }
            } else {
                serviceDegradationList = new ArrayList<ServiceDegradationDomain>();
                serviceDegradationList.add(serviceDegradationDomain);
                serviceDegradationListObj.setServiceDegradationList(serviceDegradationList);
            }
        } else {
            serviceDegradationList = new ArrayList<ServiceDegradationDomain>();
            serviceDegradationList.add(serviceDegradationDomain);
            serviceDegradationListObj = new ServiceDegradationList();
            serviceDegradationListObj.setServiceDegradationList(serviceDegradationList);
        }
        try {
            this.getAfo().writeObject((Object)serviceDegradationListObj);
            this.getAfo().reload();
        }
        catch (DashboardFileException e) {
            this.log.error("", (Throwable)e);
            return 0;
        }
        return 1;
    }

    public int removeServiceDegradation(ServiceDegradationDomain serviceDegradationDomain) {
        List<ServiceDegradationDomain> serviceDegradationList = null;
        ServiceDegradationList serviceDegradationListObj = null;
        serviceDegradationListObj = (ServiceDegradationList)this.getLoadObj();
        if (serviceDegradationListObj != null && (serviceDegradationList = serviceDegradationListObj.getServiceDegradationList()) != null && serviceDegradationList.contains(serviceDegradationDomain)) {
            serviceDegradationList.remove(serviceDegradationDomain);
            try {
                this.getAfo().writeObject((Object)serviceDegradationListObj);
                this.getAfo().reload();
            }
            catch (DashboardFileException e) {
                this.log.error("", (Throwable)e);
                return 0;
            }
        }
        return 1;
    }
}

