/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.repository;

import cn.com.yusys.yusp.registry.governance.domain.Instance;
import cn.com.yusys.yusp.registry.governance.domain.InstanceList;
import cn.com.yusys.yusp.registry.host.config.CommonProperties;
import cn.com.yusys.yusp.registry.host.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.registry.host.exception.DashboardFileException;
import cn.com.yusys.yusp.registry.host.exception.DashboardParamException;
import cn.com.yusys.yusp.registry.host.repository.CommonRepository;
import cn.com.yusys.yusp.registry.log.util.LogUtil;
import cn.com.yusys.yusp.registry.log.util.ModulNameConstant;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Repository;

@Repository
@EnableConfigurationProperties(value={ConfigFileConfiguration.class})
public class InstanceRepository
extends CommonRepository {
    public InstanceRepository(ConfigFileConfiguration properties) {
        super((CommonProperties)properties.getRegistryStore());
    }

    public JavaType getJavaType() {
        return TypeFactory.defaultInstance().constructType(InstanceList.class);
    }

    public InstanceList getInstanceList() {
        InstanceList instanceList = (InstanceList)this.getLoadObj();
        if (instanceList == null) {
            instanceList = new InstanceList();
        }
        if (instanceList.getInstanceList() == null) {
            instanceList.setInstanceList(new ArrayList<Instance>());
        }
        return instanceList;
    }

    public List<Instance> getList() {
        return this.getInstanceList().getInstanceList();
    }

    public void updateInstance(Instance instance) throws DashboardParamException {
        InstanceList instances = new InstanceList();
        List<Instance> instanceList = this.getList();
        boolean updateStatus = false;
        for (Instance inst : instanceList) {
            if (!inst.getUrl().equals(instance.getUrl())) continue;
            inst.setWeighted(instance.getWeighted());
            inst.setLable(instance.getLable());
            updateStatus = true;
        }
        if (!updateStatus) {
            instanceList.add(instance);
        }
        instances.setInstanceList(instanceList);
        try {
            this.getAfo().writeObject((Object)instances);
            LogUtil.info((Object)ModulNameConstant.INSTANCE_MANAGER, (String)"{}\u5b9e\u4f8b[{}]\u914d\u7f6e\u4fe1\u606f", (Object[])new Object[]{updateStatus ? "\u4fee\u6539" : "\u65b0\u589e", instance.getName()});
        }
        catch (DashboardFileException e) {
            LogUtil.error((Object)ModulNameConstant.INSTANCE_MANAGER, (String)"{}\u5b9e\u4f8b[{}]\u914d\u7f6e\u4fe1\u606f", (Object[])new Object[]{updateStatus ? "\u4fee\u6539" : "\u65b0\u589e", instance.getName()});
            e.printStackTrace();
        }
    }
}

