/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.repository;

import cn.com.yusys.yusp.registry.governance.domain.ElkUrlDomain;
import cn.com.yusys.yusp.registry.governance.domain.ElkUrlDomainList;
import cn.com.yusys.yusp.registry.host.config.CommonProperties;
import cn.com.yusys.yusp.registry.host.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.registry.host.repository.CommonRepository;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.ArrayList;
import java.util.List;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Repository;

@EnableConfigurationProperties(value={ConfigFileConfiguration.class})
@Repository
public class ElkUrlRepository
extends CommonRepository {
    private final Logger logger = LoggerFactory.getLogger(ElkUrlRepository.class);

    public ElkUrlRepository(ConfigFileConfiguration properties) {
        super((CommonProperties)properties.getRegistryStore());
    }

    public JavaType getJavaType() {
        return TypeFactory.defaultInstance().constructType(ElkUrlDomainList.class);
    }

    public ElkUrlDomainList getDoaminList() {
        ElkUrlDomainList infoList = (ElkUrlDomainList)this.getLoadObj();
        if (infoList == null) {
            infoList = new ElkUrlDomainList();
        }
        if (infoList.getElkUrlInfo() == null) {
            infoList.setElkUrlInfo(new ArrayList<ElkUrlDomain>());
        }
        return infoList;
    }

    public ElkUrlDomain getElkUrl(String relMenu) {
        ElkUrlDomain elkUrlDomain = null;
        List<ElkUrlDomain> elkUrlList = this.getDoaminList().getElkUrlInfo();
        for (ElkUrlDomain elk : elkUrlList) {
            if (!StringUtils.equals((String)relMenu, (String)elk.getRelMenu())) continue;
            elkUrlDomain = elk;
            break;
        }
        return elkUrlDomain;
    }
}

