/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.repository;

import cn.com.yusys.yusp.registry.governance.domain.DeployInfo;
import cn.com.yusys.yusp.registry.governance.install.DeployStatus;
import cn.com.yusys.yusp.registry.host.config.CommonProperties;
import cn.com.yusys.yusp.registry.host.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.registry.host.exception.DashboardFileException;
import cn.com.yusys.yusp.registry.host.exception.DashboardParamException;
import cn.com.yusys.yusp.registry.host.repository.CommonRepository;
import cn.com.yusys.yusp.registry.log.util.LogUtil;
import cn.com.yusys.yusp.registry.log.util.ModulNameConstant;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Repository;

@Repository
@EnableConfigurationProperties(value={ConfigFileConfiguration.class})
public class DeployRepository
extends CommonRepository {
    public DeployRepository(ConfigFileConfiguration properties) {
        super((CommonProperties)properties.getDeployInfo());
    }

    public JavaType getJavaType() {
        TypeFactory factory = TypeFactory.defaultInstance();
        return factory.constructParametricType(List.class, new Class[]{DeployInfo.class});
    }

    public List<DeployInfo> getList() {
        ArrayList instanceList = (ArrayList)this.getLoadObj();
        if (instanceList == null) {
            instanceList = new ArrayList();
        }
        return instanceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(DeployInfo deployInfo) throws DashboardParamException {
        DeployRepository deployRepository = this;
        synchronized (deployRepository) {
            List<DeployInfo> deployList = this.getList();
            boolean updateStatus = false;
            for (DeployInfo deploy : deployList) {
                if (deploy.getDeployId().equals(deployInfo.getDeployId())) {
                    BeanUtils.copyProperties((Object)deployInfo, (Object)deploy);
                    updateStatus = true;
                    continue;
                }
                if (!deploy.getName().equals(deployInfo.getName()) || !deploy.getIp().equals(deployInfo.getIp())) continue;
                BeanUtils.copyProperties((Object)deployInfo, (Object)deploy);
                updateStatus = true;
            }
            if (!updateStatus) {
                deployList.add(deployInfo);
            }
            try {
                this.getAfo().writeObject(deployList);
                LogUtil.info((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"{}\u5b9e\u4f8b[{}]\u914d\u7f6e\u4fe1\u606f", (Object[])new Object[]{updateStatus ? "\u4fee\u6539" : "\u65b0\u589e", deployInfo.getName() + "|" + deployInfo.getIp()});
            }
            catch (DashboardFileException e) {
                LogUtil.error((Object)ModulNameConstant.APPLICATION_INSTALL, (String)"{}\u5b9e\u4f8b[{}]\u914d\u7f6e\u4fe1\u606f", (Object[])new Object[]{updateStatus ? "\u4fee\u6539" : "\u65b0\u589e", deployInfo.getName() + "|" + deployInfo.getIp()});
                e.printStackTrace();
            }
        }
    }

    public void updateDeployState(DeployStatus deployStatus, DeployInfo deployInfo) {
        deployInfo.setDeployNo(deployStatus.getStepNo());
        deployInfo.setDeployDesc(deployStatus.getDesc());
        try {
            this.update(deployInfo);
        }
        catch (DashboardParamException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DeployInfo deployInfo) {
        DeployRepository deployRepository = this;
        synchronized (deployRepository) {
            List<DeployInfo> deployList = this.getList();
            DeployInfo deploy = null;
            for (DeployInfo d : deployList) {
                if (!d.getName().equals(deployInfo.getName()) || !d.getIp().equals(deployInfo.getIp())) continue;
                deploy = d;
            }
            if (deploy != null) {
                deployList.remove(deploy);
                try {
                    this.getAfo().writeObject(deployList);
                }
                catch (DashboardFileException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

