/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.repository;

import cn.com.yusys.yusp.registry.governance.domain.Datacode;
import cn.com.yusys.yusp.registry.host.config.CommonProperties;
import cn.com.yusys.yusp.registry.host.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.registry.host.repository.CommonRepository;
import cn.com.yusys.yusp.registry.host.ssh.Utils;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Repository;

@EnableConfigurationProperties(value={ConfigFileConfiguration.class})
@Repository
public class DataDictonaryRepository
extends CommonRepository {
    private final Logger logger = LoggerFactory.getLogger(DataDictonaryRepository.class);
    private JavaType javaType;

    public DataDictonaryRepository(ConfigFileConfiguration properties) {
        super((CommonProperties)properties.getRegistryStore());
    }

    public JavaType getJavaType() {
        if (this.javaType == null) {
            TypeFactory factory = TypeFactory.defaultInstance();
            JavaType keyType = factory.constructType(String.class);
            JavaType valueType = factory.constructParametricType(List.class, new Class[]{Datacode.class});
            this.javaType = factory.constructMapType(Map.class, keyType, valueType);
        }
        return this.javaType;
    }

    public Map<String, List<Datacode>> getDataDictionary() {
        HashMap map = (HashMap)this.getLoadObj();
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    public List<Datacode> getCodeListByName(String name) {
        this.logger.info("\u83b7\u53d6\u5b57\u5178\u7c7b\u578b:{}\u7684\u5b57\u5178\u9879", (Object)name);
        List<Datacode> list = this.getDataDictionary().get(name);
        if (list == null) {
            list = new ArrayList<Datacode>();
        }
        return list;
    }

    public int removeDictByName(String name) {
        this.logger.info("\u79fb\u9664\u5b57\u5178\u7c7b\u578b:{}", (Object)name);
        if (StringUtils.isEmpty((CharSequence)name)) {
            return 1;
        }
        Map<String, List<Datacode>> map = this.getDataDictionary();
        map.remove(name);
        return this.writeObject(map);
    }

    public int alterDictByName(String oldName, String newName) {
        Map<String, List<Datacode>> map;
        this.logger.info("\u53d8\u66f4\u5b57\u5178\u7c7b\u522b:{}\u4e3a:{}", (Object)oldName, (Object)newName);
        if (StringUtils.isNotEmpty((CharSequence)oldName) && StringUtils.isNotEmpty((CharSequence)newName) && (map = this.getDataDictionary()).get(oldName) != null) {
            map.put(newName, map.get(oldName));
            map.remove(oldName);
            return this.writeObject(map);
        }
        return 1;
    }

    public int maintainDatacodeByName(String name, Datacode datacode) {
        this.logger.info("\u53d8\u66f4\u5b57\u5178\u7c7b\u578b:{}\u7684\u5b57\u5178\u9879:{}", (Object)name, (Object)datacode);
        if (name == null || datacode == null) {
            return 1;
        }
        if (StringUtils.isEmpty((CharSequence)datacode.getKey())) {
            datacode.setKey(Utils.getUuid());
        }
        Map<String, List<Datacode>> map = this.getDataDictionary();
        List<Datacode> list = this.getCodeListByName(name);
        try {
            Field keyField = Datacode.class.getDeclaredField("key");
            this.updateList(list, datacode, keyField, false);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        map.put(name, list);
        return this.writeObject(map);
    }

    public int removeDataCodeByName(String name, String[] keys) {
        this.logger.info("\u6279\u91cf\u5220\u9664\u5b57\u5178\u7c7b\u578b:{}\u7684\u5b57\u5178\u9879:{}", (Object)name, (Object)keys);
        if (StringUtils.isNotEmpty((CharSequence)name) && StringUtils.isNoneEmpty((CharSequence[])keys)) {
            Map<String, List<Datacode>> map = this.getDataDictionary();
            List<Datacode> list = this.getCodeListByName(name);
            boolean success = false;
            try {
                Field keyField = Datacode.class.getDeclaredField("key");
                success = this.removeByKeys(list, keyField, keys);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            if (success) {
                map.put(name, list);
                return this.writeObject(map);
            }
        }
        return 1;
    }
}

