/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.install;

import cn.com.yusys.yusp.registry.governance.config.ServiceFileProperties;
import cn.com.yusys.yusp.registry.governance.domain.DeployInfo;
import cn.com.yusys.yusp.registry.governance.domain.DeployInfoHistory;
import cn.com.yusys.yusp.registry.governance.domain.VersionInfo;
import cn.com.yusys.yusp.registry.governance.install.DeployMonitor;
import cn.com.yusys.yusp.registry.governance.install.DeployStatus;
import cn.com.yusys.yusp.registry.governance.install.DeployUtil;
import cn.com.yusys.yusp.registry.governance.repository.ApplicationRepository;
import cn.com.yusys.yusp.registry.governance.repository.DeployHistoryRepository;
import cn.com.yusys.yusp.registry.governance.repository.DeployRepository;
import cn.com.yusys.yusp.registry.governance.repository.ServiceFlexHistoryRepository;
import cn.com.yusys.yusp.registry.host.common.DashboardCmdPair;
import cn.com.yusys.yusp.registry.host.domain.HostDomain;
import cn.com.yusys.yusp.registry.host.exception.DashboardFileException;
import cn.com.yusys.yusp.registry.host.exception.DashboardParamException;
import cn.com.yusys.yusp.registry.host.exception.DashboardSessionException;
import cn.com.yusys.yusp.registry.host.repository.HostRepository;
import cn.com.yusys.yusp.registry.host.ssh.cmd.SimpleCmd;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@EnableConfigurationProperties(value={ServiceFileProperties.class})
@Component
public class ServiceInstall {
    private static final Logger log = LoggerFactory.getLogger(ServiceInstall.class);
    @Autowired
    HostRepository hostRepository;
    @Autowired
    ServiceFileProperties serviceFileProperties;
    @Autowired
    ServiceFlexHistoryRepository expandHistoryRepository;
    @Autowired
    ApplicationRepository applicationRepository;
    @Autowired
    DeployHistoryRepository deployInfoHistoryRepository;
    @Autowired
    DeployRepository deployRepository;
    @Autowired
    DeployMonitor deployMonitor;
    @Value(value="${deploy-file-path}")
    String deployFilePath;
    private String startShellName;
    private DeployStatus deployStatus;
    private DeployInfo deployInfo;
    private DeployInfoHistory deployInfoHistory;

    public void install(DeployInfo deployInfo, VersionInfo versionInfo, HostDomain hostInfo) throws Exception {
        String result = "success";
        String appName = versionInfo.getFileName();
        String fielFullPath = this.serviceFileProperties.getPath(versionInfo.getName()) + appName;
        this.deployInfo = deployInfo;
        this.deployInfoHistory = this.buildHistory(deployInfo, versionInfo, hostInfo);
        String targetPath = deployInfo.getDeployPath();
        String logFileName = deployInfo.getLogFile();
        String jvmOpts = deployInfo.getJvmOpts();
        String bootOpts = deployInfo.getBootOpts();
        try {
            this.chk(hostInfo.getHostName(), targetPath);
            log.info("file source path :{}, target path: {}", (Object)fielFullPath, (Object)targetPath);
            this.upLoadServiceFile(hostInfo.getHostName(), fielFullPath, targetPath);
            this.deploy(hostInfo.getHostName(), targetPath, appName, logFileName, jvmOpts, bootOpts, versionInfo.getName());
            this.addMonitor();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = this.deployStatus.getDesc() + "\u5931\u8d25,\u9519\u8bef\u539f\u56e0:[" + e.getMessage() + "]";
            log.error(result);
            try {
                deployInfo.setDeployResult(result);
                deployInfo.setEndTime(DateTime.now().toString("yyyy-MM-dd HH:mm:ss"));
                this.deployRepository.update(deployInfo);
            }
            catch (DashboardParamException e1) {
                e1.printStackTrace();
            }
            throw e;
        }
        finally {
            this.deployInfoHistoryRepository.updateHistory(this.deployInfoHistory);
        }
    }

    private void addMonitor() {
        this.deployMonitor.add(this.deployInfo);
    }

    private void chk(String hostName, String targetPath) throws Exception {
        this.deployStatus = DeployStatus.CHECK;
        this.startShellName = this.getStartFileName();
        this.uploadStartFile(hostName, targetPath);
        this.deployRepository.updateDeployState(this.deployStatus, this.deployInfo);
    }

    private String getStartFileName() throws Exception {
        return this.deployFilePath.substring(this.deployFilePath.lastIndexOf(DeployUtil.getFileSeparator()) + 1);
    }

    private void uploadStartFile(String hostName, String targetPath) throws Exception {
        InputStream inputStream = null;
        try {
            File file = new File(this.deployFilePath);
            if (!file.exists()) {
                ClassPathResource resource = new ClassPathResource(this.deployFilePath);
                inputStream = resource.getInputStream();
            } else {
                inputStream = new FileInputStream(file);
            }
            this.hostRepository.upload(hostName, inputStream, this.getStartFileName(), DeployUtil.getBinPath(targetPath), false);
        }
        catch (DashboardSessionException | JSchException | SftpException | FileNotFoundException e) {
            throw e;
        }
        finally {
            try {
                if (Objects.nonNull(inputStream)) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private DeployInfoHistory buildHistory(DeployInfo deployInfo, VersionInfo versionInfo, HostDomain hostInfo) {
        this.deployStatus = DeployStatus.BEGIN;
        String startTime = DateTime.now().toString("yyyy-MM-dd HH:mm:ss");
        DeployInfoHistory deployInfoHistory = new DeployInfoHistory();
        BeanUtils.copyProperties((Object)deployInfo, (Object)deployInfoHistory);
        deployInfoHistory.setUpdateTime(startTime);
        deployInfoHistory.setUpdateType("\u53d1\u5e03");
        deployInfo.setStartTime(startTime);
        this.deployRepository.updateDeployState(this.deployStatus, deployInfo);
        return deployInfoHistory;
    }

    private void upLoadServiceFile(String hostName, String fielFullPath, String targetPath) throws FileNotFoundException, DashboardSessionException, JSchException, SftpException {
        File file = new File(fielFullPath);
        this.deployStatus = DeployStatus.UPLOAD;
        this.hostRepository.upload(hostName, file, DeployUtil.getAppPath(targetPath), true);
        this.deployRepository.updateDeployState(this.deployStatus, this.deployInfo);
    }

    private void deploy(String hostName, String targetPath, String appName, String logName, String jvmOpts, String bootOpts, String serviceName) throws DashboardFileException, DashboardSessionException {
        this.deployStatus = DeployStatus.STARTING;
        DashboardCmdPair cmdPair = this.hostRepository.goCmd(hostName, DeployUtil.getBinPath(targetPath), SimpleCmd.shellStart((String)this.startShellName, (String)appName, (String)logName, (String)jvmOpts, (String)bootOpts));
        this.deployInfo.setDeployResult(cmdPair.getOut());
        this.deployRepository.updateDeployState(this.deployStatus, this.deployInfo);
    }

    public String sendCmdStart(DeployInfo deployInfo) throws Exception {
        String shellName = this.getStartFileName();
        DashboardCmdPair dashboardCmdPair = this.hostRepository.goCmd(deployInfo.getHostName(), DeployUtil.getBinPath(deployInfo.getDeployPath()), SimpleCmd.shellStart((String)shellName, (String)deployInfo.getAppName(), (String)deployInfo.getLogFile(), (String)deployInfo.getJvmOpts(), (String)deployInfo.getBootOpts()));
        return dashboardCmdPair.getOut();
    }
}

