/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.install;

import cn.com.yusys.yusp.registry.host.domain.HostDomain;
import cn.com.yusys.yusp.registry.host.exception.DashboardSessionException;
import cn.com.yusys.yusp.registry.host.repository.HostRepository;
import cn.com.yusys.yusp.registry.host.ssh.cmd.SimpleCmd;
import cn.com.yusys.yusp.registry.host.util.SpringContextUtil;
import org.apache.commons.lang.StringUtils;

public class DeployUtil {
    private static final String DEFAULT_ROOT_PATH = "/home/";
    private static final String DEFUALT_USER_NAME = "registry";
    public static final String APP_FOLDER_NAME = "app";
    public static final String BIN_FOLDER_NAME = "bin";
    public static final String LOG_FOLDER_NAME = "log";

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getBinPath(String targetPath) {
        return targetPath + DeployUtil.getFileSeparator() + BIN_FOLDER_NAME;
    }

    public static String getLogPath(String targetPath) {
        return targetPath + DeployUtil.getFileSeparator() + LOG_FOLDER_NAME;
    }

    public static String getAppPath(String targetPath) {
        return targetPath + DeployUtil.getFileSeparator() + APP_FOLDER_NAME;
    }

    public static String getTargetPath(HostDomain hostInfo) {
        HostRepository hostRepository = (HostRepository)SpringContextUtil.getBean(HostRepository.class);
        String fileTargetPath = "";
        try {
            fileTargetPath = hostRepository.goCmd(hostInfo.getHostName(), SimpleCmd.getHomePath()).trim().replace("\n", "");
        }
        catch (DashboardSessionException e) {
            e.printStackTrace();
            fileTargetPath = StringUtils.isEmpty((String)hostInfo.getUserName()) ? "/home/registry" : DEFAULT_ROOT_PATH + hostInfo.getUserName();
        }
        return fileTargetPath;
    }
}

