/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.install;

import cn.com.yusys.yusp.registry.governance.domain.Application;
import cn.com.yusys.yusp.registry.governance.domain.DeployInfo;
import cn.com.yusys.yusp.registry.governance.domain.Instance;
import cn.com.yusys.yusp.registry.governance.install.DeployStatus;
import cn.com.yusys.yusp.registry.governance.repository.ApplicationRepository;
import cn.com.yusys.yusp.registry.governance.repository.DeployRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnBean(value={DeployRepository.class})
public class DeployMonitor {
    private static final Logger log = LoggerFactory.getLogger(DeployMonitor.class);
    @Autowired
    private ApplicationRepository repository;
    private DeployRepository deployRepository;
    private static final long CHK_OUT_TIME = 300000L;
    private static final long DEPLOY_VALID_TIME = 3600000L;
    private static DateTimeFormatter format = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private Map<String, DeployInfo> deployMap = new HashMap<String, DeployInfo>();
    private boolean run = false;

    public DeployMonitor(DeployRepository deployRepository) {
        this.deployRepository = deployRepository;
        this.init();
    }

    public void add(DeployInfo deployInfo) {
        this.deployMap.put(deployInfo.getDeployId(), deployInfo);
    }

    public void remove(DeployInfo deployInfo) {
        this.deployMap.remove(deployInfo.getDeployId());
    }

    public Map<String, DeployInfo> findAll() {
        return this.deployMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0/2 * * * * ?")
    public void monitor() {
        log.debug("run:{}", (Object)this.run);
        if (!this.run) {
            this.run = true;
            try {
                for (String key : this.deployMap.keySet()) {
                    DeployInfo deployInfo = this.deployMap.get(key);
                    log.debug("key:{}, deployInfo:{}", (Object)key, (Object)deployInfo);
                    if (!StringUtils.isEmpty((CharSequence)deployInfo.getStartTime())) {
                        long startTime = DateTime.parse((String)deployInfo.getStartTime(), (DateTimeFormatter)format).getMillis();
                        if (System.currentTimeMillis() - startTime > 300000L) {
                            log.warn("\u5b9e\u4f8b[{}][{}],\u68c0\u67e5\u8d85\u65f6\uff0c\u5df2\u79fb\u9664", (Object)deployInfo.getName(), (Object)deployInfo.getIp());
                            deployInfo.setEndTime(DateTime.now().toString(format));
                            deployInfo.setDeployResult(deployInfo.getDeployDesc() + ":" + DeployStatus.TIMEOUT.getDesc());
                            this.deployRepository.update(deployInfo);
                            this.remove(deployInfo);
                            continue;
                        }
                        Application application = this.repository.findByName(deployInfo.getName());
                        if (application != null) {
                            List<Instance> instanceList = application.getInstances();
                            for (Instance instance : instanceList) {
                                if (!instance.getIp().equals(deployInfo.getIp())) continue;
                                log.info("\u5b9e\u4f8b[{}][{}],\u5df2\u6b63\u5e38\u8fd0\u884c", (Object)deployInfo.getName(), (Object)deployInfo.getIp());
                                deployInfo.setEndTime(DateTime.now().toString(format));
                                deployInfo.setPort(instance.getPort());
                                deployInfo.setDeployResult("\u6210\u529f");
                                this.deployRepository.updateDeployState(DeployStatus.RUNNING, deployInfo);
                                this.remove(deployInfo);
                                break;
                            }
                        }
                    }
                    if (StringUtils.isEmpty((CharSequence)deployInfo.getOpDate())) continue;
                    long opDate = DateTime.parse((String)deployInfo.getOpDate(), (DateTimeFormatter)format).getMillis();
                    if (System.currentTimeMillis() - opDate <= 3600000L) continue;
                    log.warn("\u5b9e\u4f8b[{}][{}],\u53d1\u5e03\u8d85\u65f6\uff0c\u5df2\u79fb\u9664", (Object)deployInfo.getName(), (Object)deployInfo.getIp());
                    deployInfo.setEndTime(DateTime.now().toString(format));
                    deployInfo.setDeployResult(deployInfo.getDeployDesc() + ":" + DeployStatus.TIMEOUT.getDesc());
                    this.deployRepository.update(deployInfo);
                    this.remove(deployInfo);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                this.run = false;
            }
        }
    }

    public void init() {
        List<DeployInfo> list = this.deployRepository.getList();
        if (list != null && list.size() > 0) {
            List unFinsh = list.stream().filter(d -> StringUtils.isEmpty((CharSequence)d.getEndTime())).collect(Collectors.toList());
            for (DeployInfo deployInfo : unFinsh) {
                this.deployMap.put(deployInfo.getDeployId(), deployInfo);
            }
        }
    }
}

