/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.executor;

import cn.com.yusys.yusp.registry.governance.domain.MonitorResult;
import cn.com.yusys.yusp.registry.governance.domain.WarnRule;
import cn.com.yusys.yusp.registry.governance.domain.jsonObj.Metric;
import cn.com.yusys.yusp.registry.governance.executor.AbstractClusterMonitor;
import cn.com.yusys.yusp.registry.governance.service.ElasticsearchMetricsService;
import cn.com.yusys.yusp.registry.governance.web.rest.util.Constants;
import cn.com.yusys.yusp.registry.log.util.LogUtil;
import cn.com.yusys.yusp.registry.log.util.ModulNameConstant;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WarnMonitor
extends AbstractClusterMonitor {
    @Autowired
    private ElasticsearchMetricsService elasticsearchMetricsService;
    Map<String, Integer> CountMap = new ConcurrentHashMap<String, Integer>();

    public MonitorResult beyondIndex(WarnRule warnRule) {
        MonitorResult result = new MonitorResult();
        HashMap<String, Object> map0 = new HashMap<String, Object>();
        StringBuffer content = new StringBuffer();
        String ruleDesc = warnRule.getRuleDesc();
        Metric metric = null;
        String json = null;
        Gson gson = new Gson();
        int interval = 1;
        if (warnRule.getInterval().substring(warnRule.getInterval().length() - 1, warnRule.getInterval().length()).equals("M")) {
            interval = Integer.parseInt(warnRule.getInterval().split("M")[0]);
        }
        if (warnRule.getType().equals("host")) {
            json = this.elasticsearchMetricsService.getNodesMetrics(interval, "M");
            metric = (Metric)gson.fromJson(json, Metric.class);
            List<Map<String, Object>> buckets = metric.getAggregations().getService_nodes().getBuckets();
            for (Map<String, Object> b : buckets) {
                Object v0;
                if (!warnRule.getSource().equalsIgnoreCase((String)b.get("key"))) continue;
                double val = 0.0;
                if (ruleDesc.equals("disk-used")) {
                    v0 = ((Map)b.get("disk-used")).get("value");
                    Object v1 = ((Map)b.get("disk-total")).get("value");
                    if (v0 != null && v1 != null) {
                        val = (Double)v0 / (Double)v1 * 100.0;
                    }
                } else {
                    v0 = ((Map)b.get(ruleDesc)).get("value");
                    if (v0 != null) {
                        val = (Double)v0 * 100.0;
                    }
                }
                if (this.compare(val, warnRule.getThreshold(), warnRule.getCondition())) {
                    this.calculateCount(warnRule.getId());
                    if (this.CountMap.get(warnRule.getId()) <= warnRule.getCount()) continue;
                    content.append("\u670d\u52a1\u5668 : " + warnRule.getSource());
                    content.append("\uff0c" + Constants.getRuleDesc(ruleDesc) + "\u4e3a" + this.formatDouble(val));
                    content.append("%\uff0c\u9884\u8b66\u6761\u4ef6\u4e3a " + (warnRule.getCondition().equals("gte") ? ">=" : "<=") + warnRule.getThreshold() + "%");
                    result.setFlag(true);
                    map0.put("content", content.toString());
                    result.setResultMap(map0);
                    LogUtil.info((Object)ModulNameConstant.WARNRULECONFIG, (String)"\u53d1\u51fa\u9884\u8b66", (Object[])new Object[]{warnRule, val});
                    this.CountMap.put(warnRule.getId(), 0);
                    continue;
                }
                this.CountMap.put(warnRule.getId(), 0);
            }
        } else {
            json = this.elasticsearchMetricsService.getAPMMetrics(interval, "M");
            metric = (Metric)gson.fromJson(json, Metric.class);
            List<Map<String, Object>> buckets = metric.getAggregations().getApm_service().getBuckets();
            for (Map<String, Object> b : buckets) {
                Object v0;
                if (!warnRule.getSource().equalsIgnoreCase((String)b.get("key"))) continue;
                double val = 0.0;
                if (warnRule.getRuleDesc().equals("rt_stats") && (v0 = ((Map)b.get(ruleDesc)).get(warnRule.getExtremum())) != null) {
                    val = (Double)v0;
                }
                if (this.compare(val, warnRule.getThreshold(), warnRule.getCondition())) {
                    this.calculateCount(warnRule.getId());
                    if (this.CountMap.get(warnRule.getId()) <= warnRule.getCount()) continue;
                    content.append("\u670d\u52a1\u540d : " + warnRule.getSource());
                    content.append("\uff0c" + Constants.getRuleDesc(ruleDesc) + Constants.getRuleDesc(warnRule.getExtremum()) + "\u4e3a" + this.formatDouble(val));
                    content.append("ms\uff0c\u9884\u8b66\u6761\u4ef6\u4e3a " + (warnRule.getCondition().equals("gte") ? ">=" : "<=") + warnRule.getThreshold() + "ms");
                    result.setFlag(true);
                    map0.put("content", content.toString());
                    result.setResultMap(map0);
                    this.CountMap.put(warnRule.getId(), 0);
                    continue;
                }
                this.CountMap.put(warnRule.getId(), 0);
            }
        }
        return result;
    }

    private void calculateCount(String id) {
        if (this.CountMap.get(id) == null) {
            this.CountMap.put(id, 1);
        } else {
            int count = this.CountMap.get(id);
            this.CountMap.put(id, ++count);
        }
    }
}

