/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.executor;

import cn.com.yusys.yusp.registry.governance.domain.Application;
import cn.com.yusys.yusp.registry.governance.domain.IndexDomain;
import cn.com.yusys.yusp.registry.governance.domain.Instance;
import cn.com.yusys.yusp.registry.governance.domain.MonitorResult;
import cn.com.yusys.yusp.registry.governance.domain.jsonObj.Metric;
import cn.com.yusys.yusp.registry.governance.executor.AbstractClusterMonitor;
import cn.com.yusys.yusp.registry.governance.repository.ApplicationRepository;
import cn.com.yusys.yusp.registry.governance.service.ElasticsearchMetricsService;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlexMonitor
extends AbstractClusterMonitor {
    @Autowired
    private ElasticsearchMetricsService elasticsearchMetricsService;
    @Autowired
    private ApplicationRepository applicationRepository;

    public MonitorResult beyondIndex(IndexDomain indexDomain) {
        MonitorResult result = new MonitorResult();
        Metric metric = null;
        String json = null;
        Gson gson = new Gson();
        if (indexDomain.getType().equals("host")) {
            List<Instance> instances;
            json = this.elasticsearchMetricsService.getNodesMetrics(1, "M");
            metric = (Metric)gson.fromJson(json, Metric.class);
            List<Map<String, Object>> buckets = metric.getAggregations().getService_nodes().getBuckets();
            Application application = this.applicationRepository.findByName(indexDomain.getServiceName());
            ArrayList<String> ips = new ArrayList<String>();
            ArrayList<String> hostNames = new ArrayList<String>();
            if (application != null && (instances = application.getInstances()) != null) {
                for (Instance i : instances) {
                    ips.add(i.getIp());
                    if (!StringUtils.isNotBlank((CharSequence)i.getName())) continue;
                    hostNames.add(i.getName().substring(0, i.getName().indexOf(":")));
                }
            }
            int count = 0;
            double val = 0.0;
            for (Map<String, Object> b : buckets) {
                if (!ips.contains(b.get("key")) && !hostNames.contains(b.get("key"))) continue;
                Object v0 = ((Map)b.get(indexDomain.getName())).get("value");
                if (v0 != null) {
                    val += ((Double)v0).doubleValue();
                }
                ++count;
            }
            if (this.compare(count == 0 ? 0.0 : val / (double)count, indexDomain.getThreshold(), indexDomain.getRelation())) {
                result.setFlag(true);
            }
        } else {
            json = this.elasticsearchMetricsService.getAPMMetrics(1, "M");
            metric = (Metric)gson.fromJson(json, Metric.class);
            List<Map<String, Object>> buckets = metric.getAggregations().getApm_service().getBuckets();
            for (Map<String, Object> b : buckets) {
                Object v0;
                if (indexDomain.getServiceName() == null || !indexDomain.getServiceName().equalsIgnoreCase((String)b.get("key"))) continue;
                double val = 0.0;
                if (indexDomain.getName().equals("rt_stats") && (v0 = ((Map)b.get(indexDomain.getName())).get("avg")) != null) {
                    val = (Double)v0;
                }
                if (!this.compare(val, indexDomain.getThreshold(), indexDomain.getRelation())) continue;
                result.setFlag(true);
            }
        }
        return result;
    }
}

