/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.governance.config;

import cn.com.yusys.yusp.registry.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.registry.governance.domain.WarnRule;
import cn.com.yusys.yusp.registry.governance.executor.ServiceFlexTask;
import cn.com.yusys.yusp.registry.governance.repository.ServiceInfoRepository;
import cn.com.yusys.yusp.registry.governance.service.WarnRuleService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
public class ThreadPoolTaskSchedulerConfig {
    @Autowired
    private WarnRuleService warnRuleService;
    @Autowired
    private ServiceInfoRepository serviceInfoRepository;
    @Autowired
    private ServiceFlexTask serviceFlexTask;

    @Bean
    public ThreadPoolTaskScheduler threadPoolTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(20);
        scheduler.initialize();
        return scheduler;
    }

    @EventListener
    public void FirstEventListener(ContextRefreshedEvent event) {
        List<WarnRule> lists = this.warnRuleService.getList();
        for (WarnRule warnRule : lists) {
            this.warnRuleService.startSchedule(warnRule);
        }
    }

    @Scheduled(cron="0 0/10  *  * * ?")
    public void serviceOrderTask() {
        List<ServiceInfoDomain> serviceInfoDomains = this.serviceInfoRepository.getServiceInfos();
        if (serviceInfoDomains != null) {
            this.serviceFlexTask.autoFlexService(serviceInfoDomains);
        }
    }
}

