/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.gateway.service;

import cn.com.yusys.yusp.registry.governance.domain.ServiceInfoDomain;
import cn.com.yusys.yusp.registry.governance.domain.ServiceLimitDomain;
import cn.com.yusys.yusp.registry.governance.repository.ServiceInfoRepository;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceLimiterService {
    private final Logger log = LoggerFactory.getLogger(ServiceLimiterService.class);
    @Autowired
    private ServiceInfoRepository serviceInfoRepository;

    public ServiceLimiterService(ServiceInfoRepository serviceInfoRepository) {
        this.serviceInfoRepository = serviceInfoRepository;
    }

    public List<ServiceInfoDomain> getServiceLimitInfo() {
        return this.serviceInfoRepository.getServiceInfos();
    }

    public List<ServiceLimitDomain> getLimitParameter(String name) {
        ServiceInfoDomain s = this.serviceInfoRepository.getServiceInfoByName(name);
        String[] limitMode = new String[]{"IP", "LOGIN", "URI", "QPS", "TPS"};
        List<ServiceLimitDomain> list = null;
        if (s != null) {
            list = s.getLimitDomains();
        }
        ArrayList<ServiceLimitDomain> listR = new ArrayList<ServiceLimitDomain>();
        for (int i = 0; i < limitMode.length; ++i) {
            ServiceLimitDomain limitParam = new ServiceLimitDomain();
            limitParam.setLimitMode(limitMode[i]);
            limitParam.setIntervalPeriod("60");
            limitParam.setLimitValue("100");
            limitParam.setLimitState("I");
            if (list == null || !list.contains(limitParam)) {
                listR.add(limitParam);
                continue;
            }
            int index = list.indexOf(limitParam);
            listR.add(list.get(index));
        }
        return listR;
    }

    public int updateLimitParameter(String name, ServiceLimitDomain serviceLimitDomain) {
        return this.serviceInfoRepository.upadteLimter(name, serviceLimitDomain, false, false);
    }
}

