/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.gateway.service;

import cn.com.yusys.yusp.registry.common.utils.PropertiesConvert;
import cn.com.yusys.yusp.registry.configuration.service.MicroServiceCfgService;
import cn.com.yusys.yusp.registry.host.common.ResultDto;
import cn.com.yusys.yusp.registry.log.util.LogUtil;
import cn.com.yusys.yusp.registry.log.util.ModulNameConstant;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.yaml.snakeyaml.Yaml;

@Service
public class RefreshGateway {
    private final Logger log = LoggerFactory.getLogger(RefreshGateway.class);
    @Autowired
    private MicroServiceCfgService appConfigService;
    @Autowired
    private DiscoveryClient discoveryClient;

    public ResultDto<Map<String, String>> reflushConf(String key, String value) {
        ResultDto r = new ResultDto();
        String serviceName = "gateway";
        LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u5b9e\u65f6\u5237\u65b0\u7f51\u5173\u914d\u7f6e\u4fe1\u606f[{}]->\u5f00\u59cb", (Object[])new Object[]{key});
        try {
            LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u51c6\u5907\u4fee\u6539\u914d\u7f6e\u914d\u7f6e\u4e2d\u5fc3\u6587\u4ef6,\u952e\u503c[{}]", (Object[])new Object[]{key});
            String content = this.appConfigService.getConfigContent(serviceName);
            Map m = (Map)new Yaml().loadAs(content, Map.class);
            Map flattenedMap = PropertiesConvert.converMapToFlattened((Map)m);
            flattenedMap.put(key, value);
            ObjectMapper mapper = new ObjectMapper();
            String content1 = mapper.writeValueAsString((Object)flattenedMap);
            this.appConfigService.updateConfig(serviceName, content1);
            LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u4fee\u6539\u914d\u7f6e\u914d\u7f6e\u4e2d\u5fc3\u6587\u4ef6->\u6210\u529f", (Object[])new Object[0]);
        }
        catch (Exception e) {
            this.log.error("\u4fee\u6539\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38[{}]", (Object)e.getLocalizedMessage());
            r.setCode(1);
            r.setMessage("\u4fee\u7f6e\u914d\u7f6e\u4e2d\u5fc3\u6587\u4ef6\u5f02\u5e38");
            LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u4fee\u6539\u914d\u7f6e\u914d\u7f6e\u4e2d\u5fc3\u6587\u4ef6->\u5f02\u5e38", (Object[])new Object[0]);
            return r;
        }
        try {
            LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u51c6\u5907\u5b9e\u65f6\u5237\u65b0\u670d\u52a1[{}]", (Object[])new Object[]{serviceName});
            String plainCredentials = "admin:admin";
            String base64Credentials = Base64.getEncoder().encodeToString(plainCredentials.getBytes());
            HttpHeaders headers = new HttpHeaders();
            headers.add("Authorization", "Basic " + base64Credentials);
            RestTemplate restTemplate = new RestTemplate();
            HttpEntity request = new HttpEntity((Object)("[\"" + key + "\"]"), (MultiValueMap)headers);
            List serviceInstances = this.discoveryClient.getInstances("gateway");
            for (ServiceInstance si : serviceInstances) {
                String URL2 = si.getUri() + "/management/refresh";
                ResponseEntity response = restTemplate.exchange(URL2, HttpMethod.POST, request, String.class, new Object[0]);
                this.log.info("[{}]\u8fd4\u56de->", (Object)URL2, (Object)response.toString());
            }
            LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u5b9e\u65f6\u5237\u65b0\u670d\u52a1[{}]->\u6210\u529f", (Object[])new Object[]{serviceName});
        }
        catch (Exception e) {
            this.log.error("\u5b9e\u65f6\u5237\u65b0\u670d\u52a1\u5f02\u5e38[{}]", (Object)e.getLocalizedMessage());
            r.setCode(1);
            r.setMessage("\u5b9e\u65f6\u5237\u65b0\u670d\u52a1\u5f02\u5e38");
            LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u5b9e\u65f6\u5237\u65b0\u670d\u52a1[{}]->\u5f02\u5e38", (Object[])new Object[]{serviceName});
            return r;
        }
        LogUtil.info((Object)ModulNameConstant.GATEWAY_CONFIG, (String)"\u5b9e\u65f6\u5237\u65b0\u7f51\u5173\u914d\u7f6e\u4fe1\u606f[{}]->\u7ed3\u675f", (Object[])new Object[]{key});
        return r;
    }
}

