/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.configuration.web;

import cn.com.yusys.yusp.registry.common.RefreshedInfo;
import cn.com.yusys.yusp.registry.common.domain.Application;
import cn.com.yusys.yusp.registry.common.utils.PropertiesConvert;
import cn.com.yusys.yusp.registry.common.utils.SerializeUtils;
import cn.com.yusys.yusp.registry.configuration.service.ConfigRefreshService;
import cn.com.yusys.yusp.registry.configuration.service.MicroServiceCfgService;
import cn.com.yusys.yusp.registry.log.util.LogUtil;
import cn.com.yusys.yusp.registry.log.util.ModulNameConstant;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.yaml.snakeyaml.Yaml;

@RestController
@RequestMapping(value={"/conf"})
public class MicroServiceCfgController {
    private final Logger log = LoggerFactory.getLogger(MicroServiceCfgController.class);
    @Autowired
    private MicroServiceCfgService appConfigService;
    @Autowired
    ConfigRefreshService configRefreshService;

    @RequestMapping(value={"/getApps"})
    @ResponseBody
    public Object getApps() {
        try {
            List<Application> list = this.appConfigService.getApps();
            HashSet set = new HashSet();
            for (Application app : list) {
                HashMap<String, String> m = new HashMap<String, String>();
                StringBuffer sb = new StringBuffer();
                sb.append(app.getName().toLowerCase()).append("[").append(app.getInstance().getIpAddr()).append(":").append(app.getInstance().getPort().getValue()).append("->").append(app.getInstance().getStatus()).append("]");
                m.put("name", app.getName().toLowerCase());
                m.put("id", app.getName().toLowerCase());
                set.add(m);
            }
            Map<String, Object> ret = this.data(set);
            ret.put("detail", list);
            return ret;
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            return this.error(e.getMessage());
        }
    }

    @RequestMapping(value={"/getCfg/{serviceName}"})
    public Object getCfg(@PathVariable(value="serviceName") String serviceName) {
        try {
            String content = this.appConfigService.getConfigContent(serviceName);
            Map m = (Map)new Yaml().loadAs(content, Map.class);
            Map flattenedMap = PropertiesConvert.converMapToFlattened((Map)m);
            return this.data(flattenedMap);
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            return this.error(e.getMessage());
        }
    }

    @RequestMapping(value={"/getCfgAsText/{serviceName}"})
    public Object getCfgAsText(@PathVariable(value="serviceName") String serviceName) {
        try {
            String content = this.appConfigService.getConfigContent(serviceName);
            return this.data(content);
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            return this.error(e.getMessage());
        }
    }

    @RequestMapping(value={"/updateCfg/{serviceName}"}, method={RequestMethod.POST})
    public Object updateCfg(@PathVariable(value="serviceName") String serviceName, @RequestBody String content, HttpServletRequest request) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Map contentMap = (Map)objectMapper.readValue(content, Map.class);
            String content1 = (String)contentMap.get("content");
            this.appConfigService.updateConfig(serviceName, content1);
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            return this.error(e.getMessage());
        }
        return this.data("ok");
    }

    @RequestMapping(value={"/refreshedNotify"})
    public void refreshedNotify(@RequestParam(value="refreshedInfo") String refreshedInfo) {
        RefreshedInfo info = (RefreshedInfo)SerializeUtils.decodeStr((String)refreshedInfo);
        this.log.info("\u670d\u52a1 [{}] \u4e3b\u673a [{}] \u914d\u7f6e\u5df2\u751f\u6548\uff0c \u66f4\u65b0\u5185\u5bb9 {}", new Object[]{info.getInstance(), info.getHost(), info.getRefreshedKeys()});
        LogUtil.info((Object)ModulNameConstant.MICROSERVICE_CONFIG, (String)"\u670d\u52a1 [{}] \u4e3b\u673a [{}] \u914d\u7f6e\u5df2\u751f\u6548\uff0c \u66f4\u65b0\u5185\u5bb9 {}", (Object[])new Object[]{info.getInstance(), info.getHost(), info.getRefreshedKeys()});
    }

    @RequestMapping(value={"/refreshAll/{serviceName}"})
    public Object refresh(@PathVariable(value="serviceName") String serviceName) {
        try {
            this.configRefreshService.refresh(serviceName);
            return this.data("ok");
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            return this.error(e.getMessage());
        }
    }

    @RequestMapping(value={"/refreshAll"})
    public Object refreshAll() {
        try {
            this.configRefreshService.refresh(null);
            return this.data("ok");
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            return this.error(e.getMessage());
        }
    }

    private Map<String, String> error(String msg) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("code", "-1");
        res.put("msg", msg);
        return res;
    }

    private Map<String, Object> data(Object data) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("code", "0");
        res.put("data", data);
        return res;
    }
}

