/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.configuration.service;

import cn.com.yusys.yusp.registry.common.client.ConfigServerClient;
import cn.com.yusys.yusp.registry.common.client.EurekaServerClient;
import cn.com.yusys.yusp.registry.common.domain.Application;
import cn.com.yusys.yusp.registry.common.utils.JAXBUtils;
import cn.com.yusys.yusp.registry.configuration.operator.PropertiesOperator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MicroServiceCfgService {
    private final Logger log = LoggerFactory.getLogger(MicroServiceCfgService.class);
    @Autowired
    private EurekaServerClient eurekaServerClient;
    @Autowired
    private ConfigServerClient configServerClient;
    @Autowired
    PropertiesOperator propertiesOperator;

    public List<Application> getApps() throws Exception {
        String aps = this.eurekaServerClient.getApplication();
        List apps = JAXBUtils.convertApplications((String)aps).getApplications();
        return apps;
    }

    public String getConfigContent(String serviceName) throws Exception {
        String fileName = serviceName + "-" + this.propertiesOperator.getProfile() + ".yml";
        String content = this.configServerClient.getConfigContent(fileName);
        return content;
    }

    public void updateConfig(String serviceName, String content) throws Exception {
        if (this.propertiesOperator == null) {
            throw new Exception("properties operator not init!");
        }
        this.propertiesOperator.updateProperties(serviceName, content);
    }
}

