/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.configuration.service;

import cn.com.yusys.yusp.registry.common.client.EurekaServerClient;
import cn.com.yusys.yusp.registry.common.domain.Application;
import cn.com.yusys.yusp.registry.common.utils.JAXBUtils;
import cn.com.yusys.yusp.registry.log.util.LogUtil;
import cn.com.yusys.yusp.registry.log.util.ModulNameConstant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class ConfigRefreshService {
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private EurekaServerClient eurekaServerClient;

    public void refresh(String serviceName) {
        List<Application> list = this.getApps(serviceName);
        for (Application app : list) {
            LogUtil.info((Object)ModulNameConstant.MICROSERVICE_CONFIG, (String)"\u5e94\u7528 [{}] \u914d\u7f6e\u4fee\u6539\u6210\u529f\uff0c\u5f00\u59cb\u4e0b\u53d1\u4e3b\u673a [{}]", (Object[])new Object[]{app.getName().toLowerCase(), app.getInstance().getIpAddr() + ":" + app.getInstance().getPort().getValue()});
            this.refresh(app.getName().toLowerCase(), app.getInstance().getIpAddr(), app.getInstance().getPort().getValue());
        }
    }

    public void refresh(String instance, String ip, int port) {
        StringBuilder sb = new StringBuilder();
        sb.append("http://");
        sb.append(ip).append(":").append(port);
        sb.append("/refresh");
        try {
            this.restRequest(sb.toString());
        }
        catch (Exception e) {
            LogUtil.info((Object)ModulNameConstant.MICROSERVICE_CONFIG, (String)"\u5e94\u7528 [{}] \u914d\u7f6e \u4e0b\u53d1\u4e3b\u673a [{}]\u5931\u8d25\uff0c\u539f\u56e0:{}", (Object[])new Object[]{instance, ip + ":" + port, e.getMessage()});
            e.printStackTrace();
        }
    }

    public void restRequest(String url) {
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity request = new HttpEntity((MultiValueMap)this.getHeaders());
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.POST, request, String.class, new Object[0]);
        System.out.println((String)response.getBody());
    }

    private HttpHeaders getHeaders() {
        String plainCredentials = "admin:admin";
        String base64Credentials = Base64.getEncoder().encodeToString(plainCredentials.getBytes());
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Basic " + base64Credentials);
        return headers;
    }

    private List<Application> getApps(String serviceName) {
        List<Application> list = this.getApps();
        if (serviceName == null || "".equals(serviceName.trim())) {
            return list;
        }
        ArrayList<Application> ret = new ArrayList<Application>();
        for (Application app : list) {
            if (!app.getName().toLowerCase().equals(serviceName)) continue;
            ret.add(app);
            break;
        }
        return ret;
    }

    private List<Application> getApps() {
        String aps = this.eurekaServerClient.getApplication();
        List apps = JAXBUtils.convertApplications((String)aps).getApplications();
        return apps;
    }
}

