/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.configuration.operator;

import cn.com.yusys.yusp.registry.common.client.ConfigServerClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class PropertiesProfile {
    private Environment env;
    private static final Logger log = LoggerFactory.getLogger(PropertiesProfile.class);
    private ConfigServerClient configServerClient;
    private String profile;
    private String repositoryType;
    private String propertiesLocation;

    public String getPrifle() {
        return this.profile;
    }

    public String getRepositoryType() {
        return this.repositoryType;
    }

    public void resolveProfile() {
        Object _env = null;
        if (_env == null) {
            this.localEnvParse();
        }
    }

    private void localEnvParse() {
        PropertySource propertySource = ((StandardEnvironment)this.env).getPropertySources().get("applicationConfig: [classpath:/config/bootstrap.yml]");
        String _profile = (String)propertySource.getProperty("spring.profiles.active");
        this.parseProfile(_profile);
        if (_profile != null) {
            String location;
            if (_profile.indexOf("native") != -1) {
                this.repositoryType = "native";
            }
            if ((location = this.env.getProperty("spring.cloud.config.server.native.searchLocations")) != null && location.toLowerCase().startsWith("file:")) {
                int len = "file:///".length();
                this.propertiesLocation = location.substring(len);
            } else {
                this.propertiesLocation = location;
            }
            if (this.repositoryType == null || "".equals(this.repositoryType)) {
                this.propertiesLocation = (String)propertySource.getProperty("spring.cloud.config.server.git.uri");
                if (this.propertiesLocation != null) {
                    this.repositoryType = "git";
                }
            }
        }
    }

    private void parseEnv(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(json, Map.class);
            Map prosMap = (Map)map.get("applicationConfig: [classpath:/config/application.properties]");
            if (prosMap != null) {
                this.repositoryType = (String)prosMap.get("spring.profiles.active");
                if (this.repositoryType != null) {
                    String location;
                    if (this.repositoryType.indexOf("native") != -1) {
                        this.repositoryType = "native";
                    }
                    if ((location = (String)prosMap.get("spring.cloud.config.server.native.searchLocations")).toLowerCase().startsWith("file:")) {
                        int len = "file:///".length();
                        this.propertiesLocation = location.substring(len);
                    }
                }
                if (this.repositoryType == null || "".equals(this.repositoryType)) {
                    this.propertiesLocation = (String)prosMap.get("spring.cloud.config.server.git.uri");
                    if (this.propertiesLocation != null) {
                        this.repositoryType = "git";
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    private void parseProfile(String _profile) {
        if (_profile != null) {
            this.profile = _profile.toLowerCase().indexOf("native") != -1 ? (_profile.toLowerCase().startsWith("native") ? _profile.substring(_profile.toLowerCase().indexOf(",") + 1).trim() : _profile.substring(0, _profile.toLowerCase().indexOf(",")).trim()) : _profile;
            if (this.profile == null || this.profile.equals("")) {
                this.profile = "default";
            }
        }
    }

    public String getPropertiesLocation() {
        return this.propertiesLocation;
    }

    public void setEnv(Environment env) {
        this.env = env;
    }

    public void setConfigServerClient(ConfigServerClient configServerClient) {
        this.configServerClient = configServerClient;
    }
}

