/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.configuration.operator;

import cn.com.yusys.yusp.registry.common.client.ConfigServerClient;
import cn.com.yusys.yusp.registry.configuration.listener.ServiceConfigListener;
import cn.com.yusys.yusp.registry.configuration.operator.AbstractPropertiesOperator;
import cn.com.yusys.yusp.registry.configuration.operator.GitPropertiesOperator;
import cn.com.yusys.yusp.registry.configuration.operator.NativePropertiesOperator;
import cn.com.yusys.yusp.registry.configuration.operator.PropertiesOperator;
import cn.com.yusys.yusp.registry.configuration.operator.PropertiesProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class PropertiesOperatorFactory
implements InitializingBean,
FactoryBean<PropertiesOperator> {
    private static final Logger log = LoggerFactory.getLogger(PropertiesOperatorFactory.class);
    @Autowired
    private Environment env;
    @Autowired
    protected ConfigServerClient configServerClient;
    @Autowired
    ApplicationContext applicationContext;
    private PropertiesOperator propertiesOperator;
    private boolean initOperator = false;

    public void afterPropertiesSet() throws Exception {
        PropertiesProfile propertiesProfile = new PropertiesProfile();
        propertiesProfile.setEnv(this.env);
        propertiesProfile.setConfigServerClient(this.configServerClient);
        propertiesProfile.resolveProfile();
        String repositoryType = propertiesProfile.getRepositoryType();
        if ("native".equals(repositoryType)) {
            this.propertiesOperator = new NativePropertiesOperator();
        } else if ("git".equals(repositoryType)) {
            this.propertiesOperator = new GitPropertiesOperator();
        }
        if (this.propertiesOperator == null) {
            log.warn("Cannot get  env from config server!");
            return;
        }
        AbstractPropertiesOperator operator = (AbstractPropertiesOperator)this.propertiesOperator;
        ServiceConfigListener configListener = new ServiceConfigListener();
        configListener.setConfigServerClient(this.configServerClient);
        operator.setPropertiesLocation(propertiesProfile.getPropertiesLocation());
        operator.setProfile(propertiesProfile.getPrifle());
        operator.setConfigServerClient(this.configServerClient);
        operator.setApplicationContext(this.applicationContext);
        this.initOperator = true;
    }

    public PropertiesOperator getObject() throws Exception {
        return this.propertiesOperator;
    }

    public Class<?> getObjectType() {
        return PropertiesOperator.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isInitOperator() {
        return this.initOperator;
    }
}

