/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.configuration.operator;

import cn.com.yusys.yusp.registry.common.client.ConfigServerClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLocation {
    private final Logger log = LoggerFactory.getLogger(PropertiesLocation.class);
    private ConfigServerClient configServerClient;
    private String location;
    private String profile;
    private String serviceName;

    public PropertiesLocation() {
    }

    public PropertiesLocation(String serviceName, String profile) {
        this.profile = profile;
        this.serviceName = serviceName;
    }

    public static PropertiesLocation valueOf(String serviceName, String profile) {
        return new PropertiesLocation(serviceName, profile);
    }

    public void setConfigServerClient(ConfigServerClient configServerClient) {
        this.configServerClient = configServerClient;
    }

    public String resolveLocation() {
        String info = this.configServerClient.getConfigInfo(this.serviceName, this.profile);
        this.location = this.resolveLocation(info);
        return this.location;
    }

    private String resolveLocation(String json) {
        String path = null;
        try {
            Map map1;
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(json, Map.class);
            List prosList = (List)map.get("propertySources");
            if (prosList != null && prosList.iterator().hasNext() && (map1 = (Map)prosList.iterator().next()) != null && (path = (String)map1.get("name")).toLowerCase().startsWith("file:")) {
                int len = "file:///".length();
                path = path.substring(len);
            }
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
        }
        this.log.info("properties locaiton is:{}", path);
        return path;
    }

    public static void main(String[] args) {
        PropertiesLocation p = new PropertiesLocation();
        p.profile = "dev";
        String json = "{\"name\":\"regist-server\",\"profiles\":[\"dev\"],\"label\":null,\"version\":null,\"state\":null,\"propertySources\":[{\"name\":\"file:///D:/development/springcloud/configserver/config1/regist-server-dev.properties\",\"source\":{\"eq\":\"e\",\"a\":\"b111\"}},{\"name\":\"file:///D:/development/springcloud/configserver/config1/regist-server.properties\",\"source\":{\"eq\":\"e\",\"a\":\"b\"}}]}";
        p.resolveLocation(json);
    }
}

