/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.configuration.operator;

import cn.com.yusys.yusp.registry.common.utils.PropertiesConvert;
import cn.com.yusys.yusp.registry.configuration.operator.AbstractPropertiesOperator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepository;
import org.yaml.snakeyaml.Yaml;

public class NativePropertiesOperator
extends AbstractPropertiesOperator {
    private static final Logger log = LoggerFactory.getLogger(NativePropertiesOperator.class);

    @Override
    void saveProperties(String serviceName, String content) {
        File file = new File(this.getPropertiesPath(serviceName));
        if (this.isJsonFormat(content)) {
            content = this.convertJsonToString(file, content);
        }
        if (file.isFile() && StringUtils.isNotEmpty((CharSequence)content)) {
            if (file.getPath().endsWith(".yml")) {
                this.doSaveYml(file, content);
            } else {
                this.doSaveProperties(file, content);
            }
        }
    }

    private String convertJsonToString(File file, String json) {
        String str = "";
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Map prop = (Map)objectMapper.readValue(json, Map.class);
            str = file.getPath().endsWith(".yml") ? new Yaml().dumpAsMap((Object)PropertiesConvert.convertJsonToMap((Map)prop)) : this.mapToString(prop);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    private String mapToString(Map map) {
        StringBuilder sb = new StringBuilder();
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            sb.append((String)entry.getKey());
            sb.append('=');
            sb.append((String)entry.getValue());
            if (!iter.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    private boolean isJsonFormat(String content) {
        boolean json = false;
        if (content != null && content.trim().startsWith("{") && content.trim().endsWith("}")) {
            json = true;
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveYml(File file, String content) {
        FileOutputStream outputFile = null;
        try {
            outputFile = new FileOutputStream(file);
            outputFile.write(content.getBytes("utf-8"));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            try {
                if (outputFile != null) {
                    outputFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveProperties(File file, String content) {
        Properties newProperties = new Properties();
        ByteArrayInputStream in = null;
        FileOutputStream outputFile = null;
        try {
            in = new ByteArrayInputStream(content.getBytes());
            outputFile = new FileOutputStream(file);
            newProperties.load(in);
            if (!file.exists()) {
                file.createNewFile();
            }
            newProperties.store(outputFile, "Update Properties By Web Console !");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
            try {
                if (outputFile != null) {
                    outputFile.close();
                }
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    @Override
    String getLocalLocation(String serviceName) {
        String location = null;
        try {
            location = ((NativeEnvironmentRepository)this.applicationContext.getBean(NativeEnvironmentRepository.class)).getLocations(serviceName, this.profile, null).getLocations()[0];
        }
        catch (Exception e) {
            location = ((NativeEnvironmentRepository)this.applicationContext.getBean(NativeEnvironmentRepository.class)).getSearchLocations()[0];
        }
        if (location.toLowerCase().startsWith("file:")) {
            int len = "file:///".length();
            location = location.substring(len);
        }
        return location + File.separator + serviceName + "-" + this.profile + ".yml";
    }
}

