/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.configuration.operator;

import cn.com.yusys.yusp.registry.common.client.ConfigServerClient;
import cn.com.yusys.yusp.registry.configuration.listener.PropertiesListener;
import cn.com.yusys.yusp.registry.configuration.operator.PropertiesLocation;
import cn.com.yusys.yusp.registry.configuration.operator.PropertiesOperator;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class AbstractPropertiesOperator
implements PropertiesOperator {
    private final Logger log = LoggerFactory.getLogger(AbstractPropertiesOperator.class);
    protected String profile;
    protected ApplicationContext applicationContext;
    protected List<PropertiesListener> listeners = new ArrayList<PropertiesListener>();
    private String propertiesLocation;
    private ConfigServerClient configServerClient;

    @Override
    public void updateProperties(String serviceName, String content) {
        this.log.info("Begin to save properties -> {}", (Object)(this.propertiesLocation + "/" + serviceName + "[" + this.profile + "]"));
        this.saveProperties(serviceName, content);
        this.afterChange(serviceName, content);
        this.log.info("Save properties done! ");
    }

    public String getPropertiesPath(String serviceName) {
        PropertiesLocation propertiesLocation = PropertiesLocation.valueOf(serviceName, this.profile);
        propertiesLocation.setConfigServerClient(this.configServerClient);
        String location = propertiesLocation.resolveLocation();
        if (location == null) {
            location = this.getLocalLocation(serviceName);
        }
        return location;
    }

    abstract void saveProperties(String var1, String var2);

    void afterChange(String serviceName, String content) {
        for (PropertiesListener listen : this.listeners) {
            listen.onChange(serviceName);
        }
    }

    abstract String getLocalLocation(String var1);

    public void addListener(PropertiesListener proListener) {
        this.listeners.add(proListener);
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setPropertiesLocation(String propertiesLocation) {
        this.propertiesLocation = propertiesLocation;
    }

    public void setConfigServerClient(ConfigServerClient configServerClient) {
        this.configServerClient = configServerClient;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

