/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.log.web.rest;

import cn.com.yusys.yusp.registry.host.common.ResultDto;
import cn.com.yusys.yusp.registry.host.exception.DashboardParamException;
import cn.com.yusys.yusp.registry.log.domain.OperationLog;
import cn.com.yusys.yusp.registry.log.service.OperationLogService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/operationlog"})
public class OperationLogResource {
    private final Logger log = LoggerFactory.getLogger(OperationLogResource.class);
    @Autowired
    OperationLogService operationLogService;

    @GetMapping(value={"/{name}"})
    public ResultDto<List<OperationLog>> getListByName(@PathVariable String name) {
        return new ResultDto<List<OperationLog>>(this.operationLogService.getListByName(name));
    }

    @PostMapping(value={""})
    public ResultDto<String> insert(@RequestBody OperationLog operationLog) {
        try {
            this.operationLogService.insert(operationLog);
        }
        catch (DashboardParamException e) {
            this.log.error("insert failed, message:{}", (Object)e.getMessage());
            return new ResultDto<String>(1005, 0L, "error", e.getMessage());
        }
        return new ResultDto<String>("success");
    }
}

