/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.log.util;

import cn.com.yusys.yusp.registry.host.exception.DashboardParamException;
import cn.com.yusys.yusp.registry.host.util.SpringContextUtil;
import cn.com.yusys.yusp.registry.log.domain.OperationLog;
import cn.com.yusys.yusp.registry.log.service.OperationLogService;
import cn.com.yusys.yusp.registry.log.util.LogLevelConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class LogUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LogUtil.class);

    public static void info(Object name, String opNote, Object ... param) {
        LogUtil.addLog(name, opNote, LogLevelConstant.INFO.name(), param);
    }

    public static void warn(Object name, String opNote, Object ... param) {
        LogUtil.addLog(name, opNote, LogLevelConstant.WARN.name(), param);
    }

    public static void error(Object name, String opNote, Object ... param) {
        LogUtil.addLog(name, opNote, LogLevelConstant.ERROR.name(), param);
    }

    private static void addLog(OperationLog operationLog) {
        OperationLogService service = SpringContextUtil.getBean(OperationLogService.class);
        try {
            service.insert(operationLog);
        }
        catch (DashboardParamException e) {
            LOG.error("add logg info error, message:{}", (Object)e.getMessage());
        }
    }

    private static void addLog(Object name, String opNote, String level, Object ... param) {
        if (param != null && param.length > 0) {
            opNote = MessageFormatter.arrayFormat((String)opNote, (Object[])param).getMessage();
        }
        OperationLog operationLog = new OperationLog();
        operationLog.setName(name.toString());
        operationLog.setOpNote(opNote);
        operationLog.setLevel(level);
        operationLog.setThreadId(String.valueOf(Thread.currentThread().getId()));
        LogUtil.addLog(operationLog);
    }

    public static String converClassName(String className) {
        String firstName = className.substring(0, 1);
        return firstName.toLowerCase() + className.substring(1);
    }
}

