/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.host.ssh.session;

import cn.com.yusys.yusp.registry.host.common.DashboardCmdPair;
import cn.com.yusys.yusp.registry.host.ssh.Utils;
import cn.com.yusys.yusp.registry.host.ssh.cmd.CmdTypeConstants;
import cn.com.yusys.yusp.registry.host.ssh.session.SimpleSftpMonitor;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSshSession
implements AutoCloseable {
    private final Logger log = LoggerFactory.getLogger(SimpleSshSession.class);
    private final int timeout = 3000;
    private Session session;

    public SimpleSshSession(Session session) {
        this.session = session;
    }

    public void connect() throws JSchException {
        if (!this.session.isConnected()) {
            this.session.connect();
        }
    }

    @Override
    public void close() throws Exception {
        if (Objects.nonNull(this.session)) {
            this.session.disconnect();
        }
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }

    public String getPublicKey() {
        String key = "";
        try {
            this.connect();
            if (this.session.getHostKey() != null) {
                key = this.session.getHostKey().getKey();
            }
        }
        catch (JSchException e) {
            e.printStackTrace();
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCmd(String cmd) {
        ChannelExec exec = null;
        try {
            this.connect();
            exec = (ChannelExec)this.session.openChannel("exec");
            exec.setCommand(cmd);
            exec.connect(3000);
            this.log.info("{} \u6267\u884c\u5b8c\u6210", (Object)cmd);
        }
        catch (JSchException e) {
            e.printStackTrace();
        }
        finally {
            if (exec != null) {
                exec.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String goCmd(String cmd) {
        StringBuffer sb = new StringBuffer();
        ChannelExec exec = null;
        try {
            int len;
            this.connect();
            exec = (ChannelExec)this.session.openChannel("exec");
            exec.setCommand(cmd);
            InputStream is = exec.getInputStream();
            InputStream inputStream = exec.getErrStream();
            exec.connect(3000);
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                sb.append(new String(buffer, 0, len));
            }
            if (StringUtils.isEmpty((CharSequence)sb)) {
                while ((len = inputStream.read(buffer)) != -1) {
                    sb.append(new String(buffer, 0, len));
                }
                if (StringUtils.isNotEmpty((CharSequence)sb)) {
                    sb.insert(0, "err:");
                }
            }
            this.log.info("{} \u6267\u884c\u5b8c\u6210", (Object)cmd);
            exec.disconnect();
        }
        catch (JSchException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (exec != null) {
                exec.disconnect();
            }
        }
        return sb.toString();
    }

    public DashboardCmdPair goCmd(DashboardCmdPair pair) {
        String cmd = "cd " + pair.getDir() + " && " + pair.getOut();
        String out = this.goCmd(cmd);
        if (CmdTypeConstants.isCDType(pair.getOut())) {
            pair.setDir(Utils.getNewDir(pair.getDir(), pair.getOut()));
        }
        if (out.startsWith("err:")) {
            pair.setCode(1);
        } else {
            pair.setCode(0);
        }
        pair.setOut(out);
        return pair;
    }

    public void upload(File local, String path, boolean cover) {
        try {
            FileInputStream localStream = new FileInputStream(local);
            this.upload(localStream, local.getName(), path, cover);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(InputStream localStream, String fileName, String path, boolean cover) {
        ChannelSftp sftp = null;
        try {
            this.connect();
            SimpleSftpMonitor monitor = new SimpleSftpMonitor();
            sftp = (ChannelSftp)this.session.openChannel("sftp");
            sftp.connect(3000);
            SftpATTRS attrs = null;
            try {
                attrs = sftp.stat(path);
            }
            catch (Exception ex) {
                this.log.warn("path:{} isn't exists, mkdir it", (Object)path);
            }
            if (attrs == null) {
                sftp.mkdir(path);
            }
            sftp.cd(path);
            if (cover) {
                try {
                    sftp.rm(fileName);
                }
                catch (Exception ex) {
                    this.log.warn("\u5220\u9664\u6587\u4ef6\u5931\u8d25, Message:{}", (Object)ex.getMessage());
                }
            }
            sftp.put(localStream, fileName, (SftpProgressMonitor)monitor, 1);
        }
        catch (JSchException e) {
            e.printStackTrace();
        }
        catch (SftpException e) {
            e.printStackTrace();
        }
        finally {
            if (sftp != null) {
                sftp.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String fileName, String path) {
        ChannelSftp sftp = null;
        try {
            this.connect();
            sftp = (ChannelSftp)this.session.openChannel("sftp");
            sftp.connect(3000);
            sftp.cd(path);
            try {
                sftp.rm(fileName);
            }
            catch (Exception ex) {
                this.log.warn("\u5220\u9664\u6587\u4ef6\u5931\u8d25, Message:{}", (Object)ex.getMessage());
            }
        }
        catch (JSchException e) {
            e.printStackTrace();
        }
        catch (SftpException e) {
            e.printStackTrace();
        }
        finally {
            if (sftp != null) {
                sftp.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChannelSftp.LsEntry> getFiles(String path) {
        ArrayList<ChannelSftp.LsEntry> fileList = null;
        ChannelSftp sftp = null;
        try {
            this.connect();
            fileList = new ArrayList<ChannelSftp.LsEntry>();
            sftp = (ChannelSftp)this.session.openChannel("sftp");
            sftp.connect(300000);
            Vector list = sftp.ls(path);
            for (ChannelSftp.LsEntry file : list) {
                if (file.getAttrs().isDir()) continue;
                fileList.add(file);
            }
        }
        catch (JSchException e) {
            e.printStackTrace();
        }
        catch (SftpException e) {
            e.printStackTrace();
        }
        finally {
            if (sftp != null) {
                sftp.disconnect();
            }
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downLoadFile(String srcFile, String srcPath, File outfile) {
        InputStream in = null;
        OutputStream out = null;
        ChannelSftp sftp = null;
        try {
            this.connect();
            sftp = (ChannelSftp)this.session.openChannel("sftp");
            sftp.connect(5000000);
            sftp.cd(srcPath);
            in = sftp.get(srcFile);
            out = new FileOutputStream(outfile);
            byte[] buffer = new byte[1024];
            int readLength = 0;
            while ((readLength = in.read(buffer)) != -1) {
                out.write(buffer, 0, readLength);
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (sftp != null) {
                sftp.disconnect();
            }
        }
    }
}

