/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.registry.host.service;

import cn.com.yusys.yusp.registry.host.common.DashboardCmdPair;
import cn.com.yusys.yusp.registry.host.domain.ExtHostInfo;
import cn.com.yusys.yusp.registry.host.domain.HostDomain;
import cn.com.yusys.yusp.registry.host.exception.DashboardFileException;
import cn.com.yusys.yusp.registry.host.exception.DashboardParamException;
import cn.com.yusys.yusp.registry.host.exception.DashboardSessionException;
import cn.com.yusys.yusp.registry.host.repository.HostRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HostService {
    private final Logger log = LoggerFactory.getLogger(HostService.class);
    @Autowired
    private HostRepository repository;

    public List<HostDomain> getHosts() {
        return this.repository.getHosts();
    }

    public List<HostDomain> getHostsByBusinessDomain(String businessDomain) {
        return this.repository.getHostListByBusinessDomain(businessDomain);
    }

    public List<HostDomain> getHostsByCluster(String cluster) {
        return this.repository.getHostListByCluster(cluster);
    }

    public List<ExtHostInfo> getExtHostInfo(String hostName) {
        this.log.debug("\u8bf7\u6c42\u53c2\u6570:{}", (Object)hostName);
        if (StringUtils.isEmpty((CharSequence)hostName)) {
            return null;
        }
        ExtHostInfo hostInfo = null;
        try {
            hostInfo = this.repository.getExtHostInfo(hostName);
        }
        catch (DashboardParamException e) {
            e.printStackTrace();
        }
        catch (DashboardSessionException e) {
            e.printStackTrace();
        }
        ArrayList<ExtHostInfo> list = new ArrayList<ExtHostInfo>();
        if (hostInfo != null) {
            list.add(hostInfo);
        }
        return list;
    }

    public String addHostInfo(HostDomain host) {
        this.log.debug("\u8bf7\u6c42\u53c2\u6570Host\u5bf9\u8c61:{}", (Object)host.toString());
        return this.repository.addHostInfo(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String testConn(HostDomain host) {
        this.log.debug("\u8bf7\u6c42\u53c2\u6570Host\u5bf9\u8c61:{}", (Object)host.toString());
        JSch jSch = new JSch();
        String msg = "success";
        Session session = null;
        try {
            session = jSch.getSession(host.getUserName(), host.getIp());
            session.setConfig("StrictHostKeyChecking", "no");
            session.setPassword(host.getPassword());
            session.setTimeout(3000);
            session.connect();
            host.setHostName(this.repository.goCmd(session, "hostname\n"));
        }
        catch (JSchException e) {
            e.printStackTrace();
            msg = "err: \u670d\u52a1\u5668\u8fde\u63a5\u8d85\u65f6";
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
        return msg;
    }

    public DashboardCmdPair runCmd(String hostName, String dir, String cmd) throws DashboardSessionException {
        this.log.debug("\u8bf7\u6c42\u53c2\u6570hostName:{},dir:{},cmd:{}", new Object[]{hostName, dir, cmd});
        DashboardCmdPair pair = new DashboardCmdPair(dir, cmd);
        if (StringUtils.isNotEmpty((CharSequence)cmd)) {
            try {
                pair = this.repository.goCmd(hostName, dir, cmd);
            }
            catch (DashboardFileException e) {
                e.printStackTrace();
            }
        }
        return pair;
    }

    public String delHostInfo(HostDomain host) {
        this.log.debug("\u8bf7\u6c42\u53c2\u6570Host\u5bf9\u8c61:{}", (Object)host.toString());
        return this.repository.delHostInfo(host);
    }
}

